<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Tj List.
 */
class Tj_List_Widgets extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-lists';
  }

  // widget title
  public function get_title() {
    return esc_html__('TJ List Items', 'tjcore');
  }

  // widget icon
  public function get_icon() {
    return 'eicon-editor-list-ul tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'list',
      'lists',
      'tj list',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls() {
    $this->start_controls_section(
      'section_tab',
      [
        'label'         => esc_html__('List Items', 'tjcore'),
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_icons',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'tj_icon',
        'default'          => [
          'value' => 'fa-angle-right',
          'library' => 'fa-solid',
        ],
      ]
    );
    $repeater->add_control(
      'tj_items',
      [
        'label'         => esc_html__('Item Content', 'tjcore'),
        'type'          => Controls_Manager::TEXTAREA,
        'default'       => esc_html__('List Content', 'tjcore'),
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'tj_list',
      [
        'label'         => esc_html__('List Items', 'tjcore'),
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater->get_controls(),
        'default'       => [
          [
            'tj_items'       => ' Use the latest diagnostic equipment.',

          ],
        ],
        'title_field' => '{{{ tj_items }}}',
      ]
    );
    $this->add_responsive_control(
      'list_align',
      [
        'label'                     => esc_html__('Alignment', 'tjcore'),
        'type'                      => Controls_Manager::CHOOSE,
        'options'                   => [
          'left'       => [
            'title'  => esc_html__('Left', 'tjcore'),
            'icon'   => 'eicon-text-align-left',
          ],
          'center'     => [
            'title'  => esc_html__('Center', 'tjcore'),
            'icon'   => 'eicon-text-align-center',
          ],
          'right'      => [
            'title'  => esc_html__('Right', 'tjcore'),
            'icon'   => 'eicon-text-align-right',
          ]
        ],
        'default'                   => 'left',
        'prefix_class'              => 'list_align elementor%s-align-',
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Form Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_tab_2',
      [
        'label'  => esc_html__('Listing Icon', 'tjcore'),
        'tab'    => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'list_icon_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .check-list ul li i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name' => 'list_icon_bg',
        'label' => esc_html__('Background', 'tjcore'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .check-list ul li i',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_tab_5',
      [
        'label'   => esc_html__('List Content Styling', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'      => 'tj_typography',
        'label'     => esc_html__('Typography', 'tjcore'),
        'selector'  => '{{WRAPPER}} .check-list ul li',
      ]
    );
    $this->add_responsive_control(
      'tj_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .check-list ul li' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_padding',
      [
        'label' => esc_html__('Item Padding', 'tjcore'),
        'type'  => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .check-list ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_margin',
      [
        'label' => esc_html__('Item Marign', 'tjcore'),
        'type'  => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .check-list ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render() {
    $settings        = $this->get_settings_for_display();
    $lists           = (isset($settings['tj_list']) && !empty($settings['tj_list']) ? $settings['tj_list'] : array());

    // animation
    $tjAnimation   = $settings['tj_animation'] ?? '';
    $tjAnimationName   = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $listClass = "check-list wow $tjAnimationName";
      $this->add_render_attribute('tj-list-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $listClass = "check-list";
    }
    $this->add_render_attribute('tj-list-arg', 'class', $listClass);


    if (count($lists) > 0) : ?>
      <div <?php echo $this->get_render_attribute_string('tj-list-arg'); ?>>
        <ul class="list dot-style">

          <?php foreach ($lists as $item) :
            $icons      = (isset($item['tj_icons'])) ? $item['tj_icons'] : '';
            $tj_items  = (isset($item['tj_items'])) ? $item['tj_items'] : '';
          ?>
            <li>
              <?php if ($icons != '') : ?>
                <?php tj_render_icon($item, 'tj_icons', 'tj_icon') ?>
              <?php endif; ?>
              <?php echo tj_kses($tj_items); ?>
            </li>
          <?php endforeach; ?>
        </ul>
      </div>
<?php endif;
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new Tj_List_Widgets());
