<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Marquee.
 */
class TJ_Marquee extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-marquee';
  }

  // widget title.
  public function get_title() {
    return __('TJ Marquee', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-divider-shape tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'marquee',
      'marquees',
      'tj marquee',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls() {

    // tj_title_tab
    $this->start_controls_section(
      'tj_title_tab',
      [
        'label' => esc_html__('Marquee', 'tjcore'),
        'tab' => Controls_Manager::TAB_CONTENT,
      ]
    );
    $repeater = new Repeater();
    $repeater->add_control(
      'tj_icons',
      [
        'label'         => esc_html__('Icon', 'tjcore'),
        'type'          => Controls_Manager::ICONS,
        'fa4compatibility' => 'tj_icon',
        'default'          => [
          'value' => 'fa-star',
          'library' => 'fa-solid',
        ],
      ]
    );
    $repeater->add_control(
      'tj_title',
      [
        'label'         => esc_html__('Marquee Title', 'tjcore'),
        'type'          => Controls_Manager::TEXT,
        'default'       => esc_html__('List Content', 'tjcore'),
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'tj_list',
      [
        'label'         => esc_html__('List Marquees', 'tjcore'),
        'type'          => Controls_Manager::REPEATER,
        'fields'        => $repeater->get_controls(),
        'default'       => [
          [
            'tj_title'       => 'Marketing Agency',
          ],
          [
            'tj_title'       => 'Creative Agency',
          ],
          [
            'tj_title'       => 'Marketing Agency',
          ],
          [
            'tj_title'       => 'Creative Agency',
          ],
          [
            'tj_title'       => 'Marketing Agency',
          ],
          [
            'tj_title'       => 'Creative Agency',
          ],
          [
            'tj_title'       => 'Marketing Agency',
          ],
          [
            'tj_title'       => 'Creative Agency',
          ],
        ],
        'title_field' => '{{{ tj_title }}}',
      ]
    );
    $this->add_control(
      'marquee_slide',
      [
        'label' => esc_html__('Slide Content', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => 'left-to-right',
        'options' => [
          'left-to-right' => esc_html__('Left to Right', 'tjcore'),
          'right-to-left'  => esc_html__('Right to Left', 'tjcore'),
        ],
        'separator' => 'before',
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .tj-roll-section',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-roll-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-roll-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_marquee_style',
      [
        'label' => esc_html__('Text', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'text_typography',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-roll-section .slide-roll .roll-box .roll-item .roll-content .roll-text .title',
      ]
    );
    $this->add_responsive_control(
      'text_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-roll-section .slide-roll .roll-box .roll-item .roll-content .roll-text .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'text_editor_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-roll-section .slide-roll .roll-box .roll-item .roll-content .roll-text .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'text_editor_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-roll-section .slide-roll .roll-box .roll-item .roll-content .roll-text .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      '_section_style_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_icon_size',
      [
        'label'      => esc_html__('Icon Size', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em', 'rem'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 100,
            'step' => 1,
          ],
          '%'  => [
            'min' => 0,
            'max' => 100,
          ],
        ],
        'selectors'  => [
          '{{WRAPPER}} .tj-roll-section .slide-roll .roll-box .roll-item .roll-content .roll-icon'  => 'font-size: {{SIZE}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'tj_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-roll-section .slide-roll .roll-box .roll-item .roll-content .roll-icon'  => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $marqueeList = $settings['tj_list'];
    $marqueeSlide = $settings['marquee_slide'];

    if ('left-to-right' == $marqueeSlide) {
      $slideContent = "roll-box-revers";
    } else {
      $slideContent = "";
    }

    if (!empty($marqueeList)) :
?>
      <div class="tj-roll-section overflow-hidden">
        <div class="slide-roll">
          <div class="roll-box <?php echo esc_attr($slideContent); ?>">

            <?php foreach ($marqueeList as $marquee) :
              $icons      = !empty($marquee['tj_icons']) ? $marquee['tj_icons'] : '';
              $tj_title  = !empty($marquee['tj_title']) ? $marquee['tj_title'] : '';
            ?>
              <div class="roll-item">
                <div class="roll-content">

                  <?php if ($icons != '') : ?>
                    <div class="roll-icon">
                      <?php tj_render_icon($marquee, 'tj_icons', 'tj_icon') ?>
                    </div>
                  <?php endif; ?>

                  <?php if (!empty($tj_title)) : ?>
                    <div class="roll-text">
                      <h4 class="title"><?php echo tj_kses($tj_title); ?></h4>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            <?php endforeach; ?>

          </div>

          <div class="roll-box <?php echo esc_attr($slideContent); ?>">

            <?php foreach ($marqueeList as $marquee) :
              $icons      = !empty($marquee['tj_icons']) ? $marquee['tj_icons'] : '';
              $tj_title  = !empty($marquee['tj_title']) ? $marquee['tj_title'] : '';
            ?>
              <div class="roll-item">
                <div class="roll-content">

                  <?php if ($icons != '') : ?>
                    <div class="roll-icon">
                      <?php tj_render_icon($marquee, 'tj_icons', 'tj_icon') ?>
                    </div>
                  <?php endif; ?>

                  <?php if (!empty($tj_title)) : ?>
                    <div class="roll-text">
                      <h4 class="title"><?php echo tj_kses($tj_title); ?></h4>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            <?php endforeach; ?>

          </div>
        </div>
      </div>
    <?php endif; ?>

<?php  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Marquee());
