<?php

namespace TJCore;

use Elementor\Widget_Base;
use \Elementor\Utils;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Text_Stroke;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Css_Filter;


if (!defined('ABSPATH')) exit; // Exit if accessed directly

/**
 * Elementor widget for Navigation.
 */
class Tj_Navigation_Widgets extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-navigation';
  }

  // widget title
  public function get_title() {
    return esc_html__('TJ Navigation', 'tjcore');
  }

  // widget icon
  public function get_icon() {
    return 'eicon-nav-menu tj-icon';
  }
  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'navigation',
      'navigations',
      'tj navigation',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }


  /**
   * widget controls.
   */
  protected function register_controls() {

    $menus = wp_get_nav_menus();
    $menulist = array('0' => esc_html__('None', 'tjcore'));
    if (!empty($menus)) {
      foreach ($menus as $menu) {
        $menulist[$menu->term_id] = $menu->name;
      }
    }
    $this->start_controls_section(
      '_section_content',
      [
        'label'     => esc_html__('Navigation', 'tjcore'),
      ]
    );
    $this->add_control(
      'widget_title',
      [
        'label'             => esc_html__('Widget Title', 'tjcore'),
        'type'              => Controls_Manager::TEXT,
        'label_block'       => TRUE,
        'default'           => esc_html__('All Services', 'tjcore'),
      ]
    );
    $this->add_control(
      'navigation_select',
      [
        'label'     => esc_html__('Select Navigation', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '0',
        'options'   => $menulist,
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      'section_widget_area',
      [
        'label'         => esc_html__('Widget Style', 'tjcore'),
        'tab'           => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name' => 'widget_bg',
        'label' => esc_html__('Background', 'tjcore'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .tj-services-widget',
      ]
    );
    $this->add_responsive_control(
      'widget_radius2',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-services-widget'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'widget_paddings',
      [
        'label'      => esc_html__('Paddings', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-services-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'widget_magrins',
      [
        'label'      => esc_html__('Margins', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-services-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_tab_2',
      [
        'label'         => esc_html__('Title', 'tjcore'),
        'tab'           => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'      => 'tj_typography',
        'label'     => esc_html__('Typography', 'tjcore'),
        'selector'  => '{{WRAPPER}} .tj-services-widget .side-title',
      ]
    );
    $this->add_responsive_control(
      'tj_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .tj-services-widget .side-title' => 'color: {{VALUE}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_border_bg_color',
      [
        'label'     => esc_html__('Border Color', 'tjcore'),
        'type'     => Controls_Manager::COLOR,
        'selectors'   => [
          '{{WRAPPER}} .tj-services-widget .side-title::before' => 'background: {{VALUE}};'
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_padding',
      [
        'label' => esc_html__('Paddings', 'tjcore'),
        'type'  => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-services-widget .side-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_margin',
      [
        'label' => esc_html__('Margins', 'tjcore'),
        'type'  => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .tj-services-widget .side-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // navigation
    $this->start_controls_section(
      'section_tab_3',
      [
        'label'         => esc_html__('Navigation', 'tjcore'),
        'tab'           => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'      => 'btn_typography',
        'label'     => esc_html__('Typography', 'tjcore'),
        'selector'  => '{{WRAPPER}} .services_list ul li a',
      ]
    );
    $this->start_controls_tabs('style_tabs_1');
    $this->start_controls_tab(
      'btn_1_button_style_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'btn_1_label_color',
      [
        'label' => esc_html__('Text Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .services_list ul li a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'btn_1_button_style_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'btn_1_hover_label_color',
      [
        'label' => esc_html__('Text Color', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .services_list ul li a:hover' => 'color: {{VALUE}}',
          '{{WRAPPER}} .services_list ul li.current-menu-item a' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'area_paddings',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .services_list ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'area_magrins',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .services_list ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  protected function render() {
    $settings            = $this->get_settings_for_display();

    $widget_title        = !empty($settings['widget_title']) ? $settings['widget_title'] : '';
    $navigation_select   = !empty($settings['navigation_select']) ? $settings['navigation_select'] : 0;

    // animation
    $tjAnimation   = $settings['tj_animation'] ?? '';
    $tjAnimationName   = $settings['tj_animation_name'] ?? '';
    $tjAnimationDelay   = $settings['tj_animation_delay'] ?? '';

    if (!empty($tjAnimation)) {
      $widgetClass = "tj-services-widget wow $tjAnimationName";
      $this->add_render_attribute('tj-widget-arg', 'data-wow-delay', $tjAnimationDelay['size'] . "s");
    } else {
      $widgetClass = "tj-services-widget";
    }
    $this->add_render_attribute('tj-widget-arg', 'class', $widgetClass);
?>
    <aside <?php echo $this->get_render_attribute_string('tj-widget-arg'); ?>>
      <?php if (!empty($widget_title)) : ?>
        <h3 class="side-title"><?php echo esc_html__($widget_title, 'tjcore'); ?></h3>
      <?php endif;

      if ($navigation_select > 0) :
      ?>
        <div class="services_list">
          <?php wp_nav_menu(array('menu' => $navigation_select)) ?>
        </div>
      <?php endif; ?>
    </aside>
<?php  }

  protected function content_template() {
  }
}
$widgets_manager->register(new Tj_Navigation_Widgets());
