<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Page Header.
 */
class TJ_Page_Header extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-page-header';
  }

  // widget title.
  public function get_title() {
    return __('TJ Page Header', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-header tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'page-header',
      'breadcrumb',
      'tj header',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // _tj_video_image
    $this->start_controls_section(
      'ss_section_title',
      [
        'label' => esc_html__('Content', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'type'  => Controls_Manager::TEXTAREA,
        'rows'  => '3',
      ]
    );
    $this->add_control(
      'tj_title_tag',
      [
        'label'     => esc_html__('Title HTML Tag', 'tjcore'),
        'type'      => Controls_Manager::CHOOSE,
        'options'   => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default'   => 'h1',
        'toggle'    => false,
        'separator' => 'after',
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );

    $this->add_control(
      'tj_header_navigation',
      [
        'label'        => esc_html__('Show navigation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Show', 'tjcore'),
        'label_off'    => esc_html__('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->end_controls_section();

    // _tj_hero_image
    $this->start_controls_section(
      '_tj_header_image',
      [
        'label' => esc_html__('Thumbnail', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_header_bg',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'separator' => 'before',
        'default'   => "#282828",
        'selectors' => [
          '{{WRAPPER}} .breadcrumb-wrapper' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_image',
      [
        'label'   => esc_html__('Background Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
      ]
    );
    $this->add_control(
      'tj_image_overlay',
      [
        'label'     => esc_html__('Image Overlay', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'separator' => 'before',
        'default'   => "rgba(0, 0, 0, 0)",
        'selectors' => [
          '{{WRAPPER}} .breadcrumb-wrapper::after' => 'background-color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // shapes
    $this->start_controls_section(
      '_section_shape_content',
      [
        'label' => esc_html__('Shapes', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_breadcrumb_shapes',
      [
        'label' => esc_html__('Show shapes?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
      ]
    );
    $this->add_control(
      'tj_shape_1',
      [
        'label'   => esc_html__('Shape Image 1', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'ai' => [
          'active' => false
        ],
        'condition' => [
          'tj_breadcrumb_shapes' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_shape_2',
      [
        'label'   => esc_html__('Shape Image 2', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'ai' => [
          'active' => false
        ],
        'condition' => [
          'tj_breadcrumb_shapes' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_shape_3',
      [
        'label'   => esc_html__('Shape Image 3', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'ai' => [
          'active' => false
        ],
        'condition' => [
          'tj_breadcrumb_shapes' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_shape_4',
      [
        'label'   => esc_html__('Shape Image 4', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'ai' => [
          'active' => false
        ],
        'condition' => [
          'tj_breadcrumb_shapes' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_shape_5',
      [
        'label'   => esc_html__('Shape Image 5', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'ai' => [
          'active' => false
        ],
        'condition' => [
          'tj_breadcrumb_shapes' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_shape_6',
      [
        'label'   => esc_html__('Shape Image 6', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_breadcrumb_shapes' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_shape_7',
      [
        'label'   => esc_html__('Shape Image 7', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'ai' => [
          'active' => false
        ],
        'condition' => [
          'tj_breadcrumb_shapes' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_shape_8',
      [
        'label'   => esc_html__('Shape Image 8', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'ai' => [
          'active' => false
        ],
        'condition' => [
          'tj_breadcrumb_shapes' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .breadcrumb-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .breadcrumb-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_page_title',
      [
        'label' => __('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'title_typography',
        'selector' => '{{WRAPPER}} .breadcrumb-title',
      ]
    );
    $this->add_control(
      'title_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .breadcrumb-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .breadcrumb-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .breadcrumb-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // navigation
    $this->start_controls_section(
      'style_navigation',
      [
        'label' => __('Navigation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'navigation_typography',
        'selector' => '{{WRAPPER}} .breadcrumb-link',
      ]
    );
    $this->add_control(
      'navigation_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .breadcrumb-link'          => 'color: {{VALUE}}',
          '{{WRAPPER}} .breadcrumb-link > span a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .breadcrumb-link span.current-item' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/page-header/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Page_Header());
