<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Portfolios.
 */
class TJ_Portfolios extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-portfolios';
  }

  // widget title.
  public function get_title() {
    return __('TJ Portfolios', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-posts-grid tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'portfolio',
      'portfolios',
      'tj portfolio',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Portfolios Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Portfolios Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Portfolio Query
    $this->start_controls_section(
      'tj_portfolio_query',
      [
        'label' => esc_html__('Portfolio Query', 'tjcore'),
      ]
    );
    $post_type = 'portfolios';
    $taxonomy = 'portfolios-cat';
    $this->add_control(
      'posts_per_page',
      [
        'label'       => esc_html__('Portfolios Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '6',
      ]
    );
    $this->add_control(
      'category',
      [
        'label'       => esc_html__('Include Categories', 'tjcore'),
        'description' => esc_html__('Select a category to include or leave blank for all.', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'exclude_category',
      [
        'label'       => esc_html__('Exclude Categories', 'tjcore'),
        'description' => esc_html__('Select a category to exclude', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'multiple'    => true,
        'options'     => tj_get_categories($taxonomy),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label'       => esc_html__('Include Portfolio', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label'       => esc_html__('Exclude Portfolio', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label'   => esc_html__('Offset', 'tjcore'),
        'type'    => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label'   => esc_html__('Order By', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => array(
          'ID'            => 'Post ID',
          'author'        => 'Post Author',
          'title'         => 'Title',
          'date'          => 'Date',
          'modified'      => 'Last Modified Date',
          'parent'        => 'Parent Id',
          'rand'          => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order'    => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label'   => esc_html__('Order', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'asc'  => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',

      ]
    );
    $this->add_control(
      'tj_portfolio_button_text',
      [
        'label'     => __('Button Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => tj_kses('Check <br /> Details Works'),
        'label_block'   => true,
        'condition'   => [
          'tj_design_style'  => '7',
        ],
      ]
    );
    $this->add_control(
      'category_filter',
      [
        'label'   => esc_html__('Category Filter Visibility', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'default' => 'show',
        'options' => [
          'show'   => esc_html__('Show', 'tjcore'),
          'hidden' => esc_html__('Hidden', 'tjcore'),
        ],
        'condition' => [
          'tj_design_style' => ['2', '4', '6']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_responsive_control(
      'tj_image_alignment',
      [
        'label'        => esc_html__('Alignment', 'tjcore'),
        'type'         => Controls_Manager::CHOOSE,
        'options'      => [
          'left'   => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'right'  => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default' => 'right',
        'toggle' => true,
        'selectors' => [
          '{{WRAPPER}} .tj-portfolio-filter' => 'text-align: {{VALUE}};',
        ],
        'condition' => [
          'tj_design_style' => ['2', '4', '6'],
          'category_filter' => 'show',
        ],
      ]
    );
    $this->add_control(
      'tj_filter_animation',
      [
        'label' => esc_html__('Enable Filter Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'condition' => [
          'tj_design_style' => ['2', '4', '6'],
          'category_filter' => 'show',
        ]
      ]
    );
    $this->add_control(
      'tj_filter_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_design_style' => ['2', '4', '6'],
          'tj_filter_animation' => 'yes',
          'category_filter' => 'show',
        ]
      ]
    );
    $this->add_control(
      'tj_filter_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_design_style' => ['2', '4', '6'],
          'tj_filter_animation' => 'yes',
          'category_filter' => 'show',
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .tj_portfolios',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj_portfolios' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj_portfolios' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // portfolio filter
    $this->start_controls_section(
      '_section_style_filter',
      [
        'label' => esc_html__('Filter', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['2', '4', '6']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_filter_typography',
        'selector' => '{{WRAPPER}} .tj-portfolio-filter button',
      ]
    );
    $this->add_control(
      'tj_filter_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-portfolio-filter button' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_filter4_active_color',
      [
        'label'     => __('Active Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-portfolio-filter button.active' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ["4"]
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Active Color', 'tjcore')
          ],
        ],
        'name' => 'tj_filter_active_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-portfolio-filter button.active',
        'condition' => [
          'tj_design_style!' => ["4", '6']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_filter_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-portfolio-filter button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_filter_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-portfolio-filter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    $this->start_controls_section(
      '_section_style_item_content',
      [
        'label' => esc_html__('Portfolio Item', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['7']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Hover Overlay', 'tjcore'),
          ],
        ],
        'name' => 'tj_title_gradient_color',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .portfolio-item.style-9::after',
      ]
    );
    $this->add_control(
      'Portfolio Button',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'type' => Controls_Manager::HEADING,
        'separator' => 'before',
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_button_typography',
        'selector' => '{{WRAPPER}} .portfolio-button .tj-check-btn',
      ]
    );
    $this->add_control(
      'tj_button_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .portfolio-button .tj-check-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_button_bg_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .portfolio-button' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // icon
    $this->start_controls_section(
      '_section_style_icon',
      [
        'label' => esc_html__('Icon', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ['7']
        ]
      ]
    );
    $this->add_control(
      'tj_icon_background',
      [
        'label'     => __('Background', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .portfolio-content .portfolio-icon' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .portfolio-content .portfolio-icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .portfolio-content .title, {{WRAPPER}} .portfolio-gallery .portfolio-items .portfolio-single-item .portfolio-content .title-link a, {{WRAPPER}} .portfolio-single-item.style-3 .portfolio-single .portfolio-content .portfolio-header .title-link',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .portfolio-content .title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .portfolio-gallery .portfolio-items .portfolio-single-item .portfolio-content .title-link a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .portfolio-single-item.style-3 .portfolio-single .portfolio-content .portfolio-header .title-link' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .portfolio-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .portfolio-gallery .portfolio-items .portfolio-single-item .portfolio-content .title-link a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .portfolio-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .portfolio-gallery .portfolio-items .portfolio-single-item .portfolio-content .title-link a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .portfolio-single-item.style-3 .portfolio-single .portfolio-content .portfolio-header .title-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // portfolio category
    $this->start_controls_section(
      '_section_style_cat',
      [
        'label' => esc_html__('Category', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style!' => '7'
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_category_typography',
        'selector' => '{{WRAPPER}} .tj-portfolio-item-two .portfolio-content .sub-title, {{WRAPPER}} .portfolio-gallery .portfolio-items .portfolio-single-item .portfolio-content .sub-title, {{WRAPPER}} .portfolio-single-item.style-3 .portfolio-single .portfolio-content .portfolio-header .sub-title',
      ]
    );
    $this->add_control(
      'tj_category_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-portfolio-item-two .portfolio-content .sub-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .portfolio-gallery .portfolio-items .portfolio-single-item .portfolio-content .sub-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .portfolio-single-item.style-3 .portfolio-single .portfolio-content .portfolio-header .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_category_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-portfolio-item-two .portfolio-content .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .portfolio-gallery .portfolio-items .portfolio-single-item .portfolio-content .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .portfolio-single-item.style-3 .portfolio-single .portfolio-content .portfolio-header .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_category_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-portfolio-item-two .portfolio-content .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .portfolio-gallery .portfolio-items .portfolio-single-item .portfolio-content .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .portfolio-single-item.style-3 .portfolio-single .portfolio-content .portfolio-header .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/portfolios/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Portfolios());
