<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Pricing Box.
 */
class TJ_Pricing_Box extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-pricing-box';
  }

  // widget title.
  public function get_title() {
    return __('TJ Pricing Box', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-price-table tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'pricing',
      'pricing table',
      'tj price',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // Header
    $this->start_controls_section(
      '_section_header',
      [
        'label' => __('Box Header', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'price_title',
      [
        'label'       => __('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'label_block' => true,
        'default'     => __('Basic Plan', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'price_box_icon',
      [
        'show_label'  => true,
        'type'        => Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => "price_icon",
        'default'     => [
          'value'   => 'flaticon-laurel-wreath',
          'library' => 'flaticon',
        ],
      ]
    );
    $this->add_control(
      'is_price_box_recommend',
      [
        'label'        => __('Is this recommended?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'tjcore'),
        'label_off'    => __('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_section_pricing',
      [
        'label' => __('Pricing', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'price_currency',
      [
        'label'       => __('Currency', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'label_block' => false,
        'options'     => [
          ''             => __('None', 'tjcore'),
          'baht'         => '&#3647; ' . _x('Baht', 'Currency Symbol', 'tjcore'),
          'bdt'          => '&#2547; ' . _x('BD Taka', 'Currency Symbol', 'tjcore'),
          'dollar'       => '&#36; ' . _x('Dollar', 'Currency Symbol', 'tjcore'),
          'euro'         => '&#128; ' . _x('Euro', 'Currency Symbol', 'tjcore'),
          'franc'        => '&#8355; ' . _x('Franc', 'Currency Symbol', 'tjcore'),
          'guilder'      => '&fnof; ' . _x('Guilder', 'Currency Symbol', 'tjcore'),
          'krona'        => 'kr ' . _x('Krona', 'Currency Symbol', 'tjcore'),
          'lira'         => '&#8356; ' . _x('Lira', 'Currency Symbol', 'tjcore'),
          'peseta'       => '&#8359 ' . _x('Peseta', 'Currency Symbol', 'tjcore'),
          'peso'         => '&#8369; ' . _x('Peso', 'Currency Symbol', 'tjcore'),
          'pound'        => '&#163; ' . _x('Pound Sterling', 'Currency Symbol', 'tjcore'),
          'real'         => 'R$ ' . _x('Real', 'Currency Symbol', 'tjcore'),
          'ruble'        => '&#8381; ' . _x('Ruble', 'Currency Symbol', 'tjcore'),
          'rupee'        => '&#8360; ' . _x('Rupee', 'Currency Symbol', 'tjcore'),
          'indian_rupee' => '&#8377; ' . _x('Rupee (Indian)', 'Currency Symbol', 'tjcore'),
          'shekel'       => '&#8362; ' . _x('Shekel', 'Currency Symbol', 'tjcore'),
          'won'          => '&#8361; ' . _x('Won', 'Currency Symbol', 'tjcore'),
          'yen'          => '&#165; ' . _x('Yen/Yuan', 'Currency Symbol', 'tjcore'),
          'custom'       => __('Custom', 'tjcore'),
        ],
        'default'     => 'dollar',
      ]
    );
    $this->add_control(
      'currency_custom',
      [
        'label'     => __('Custom Symbol', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'condition' => [
          'price_currency' => 'custom',
        ],
        'dynamic'   => [
          'active' => true,
        ],
      ]
    );
    $this->add_control(
      'price_price',
      [
        'label'   => __('Price', 'tjcore'),
        'type'    => Controls_Manager::TEXT,
        'default' => '60.00',
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      '_section_features',
      [
        'label' => __('Features', 'tjcore'),
      ]
    );

    $repeater = new Repeater();
    $repeater->add_control(
      'price_feature_unavailable',
      [
        'label'        => __('Feature Hide ?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Yes', 'tjcore'),
        'label_off'    => __('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $repeater->add_control(
      'price_feature_text',
      [
        'label'   => __('Text', 'tjcore'),
        'type'    => Controls_Manager::TEXTAREA,
        'default' => __('Unlimited Sub Domains', 'tjcore'),
        'dynamic' => [
          'active' => true,
        ],
      ]
    );
    $repeater->add_control(
      'tj_features_selected_icon',
      [
        'show_label'  => true,
        'type'        => Controls_Manager::ICONS,
        'label_block' => true,
        'fa4compatibility' => "tj_features_icon",
        'default'     => [
          'value'   => 'flaticon-next',
          'library' => 'flaticon',
        ],
      ]
    );
    $this->add_control(
      'price_features_list',
      [
        'type'        => Controls_Manager::REPEATER,
        'fields'      => $repeater->get_controls(),
        'show_label'  => false,
        'default'     => [
          [
            'price_feature_text'        => __('Great Customer Support', 'tjcore'),
          ],
          [
            'price_feature_text'        => __('Market Growth Solution', 'tjcore'),
          ],
          [
            'price_feature_text'        => __('Mobile Phone Optimized Ready', 'tjcore'),
          ],
          [
            'price_feature_text'        => __('Free custom domain', 'tjcore'),
          ],
          [
            'price_feature_text'        => __('Annual Purchase', 'tjcore'),
          ],
          [
            'price_feature_text'        => __('Hosting Day', 'tjcore'),
          ],
        ],
        'title_field' => '{{{ price_feature_text }}}',
      ]
    );
    $this->end_controls_section();

    // tj_btn_button_group
    $this->start_controls_section(
      'tj_btn_button_group',
      [
        'label' => esc_html__('Button', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_btn_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Choose Plan', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'       => esc_html__('Button Link Type', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'options'     => [
          '1' => 'Custom Link',
          '2' => 'Internal Page',
        ],
        'default'     => '1',
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'         => esc_html__('Button link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('https://your-link.com', 'tjcore'),
        'show_external' => false,
        'default'       => [
          'url'               => '#',
          'is_external'       => true,
          'nofollow'          => true,
          'custom_attributes' => '',
        ],
        'condition'     => [
          'tj_btn_link_type' => '1',
        ],
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page Link', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .tj-price-item',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'tj_section_box_shadow',
        'selector' => '{{WRAPPER}} .tj-price-item',
      ]
    );
    $this->add_control(
      'tj_section_border_color',
      [
        'label'     => __('Border Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item' => 'border-color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    // price box header
    $this->start_controls_section(
      '_style_price_box_header',
      [
        'label' => esc_html__('Box Header', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->start_controls_tabs(
      'pricebox_header_tabs'
    );
    $this->start_controls_tab(
      'pricebox_header_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item .price-top-content .price-icon' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name' => 'pricebox_header_background',
        'types' => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-price-item .price-top-content',
      ]
    );

    $this->end_controls_tab();

    $this->start_controls_tab(
      'pricebox_header_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_icon_hover_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item:hover .price-top-content .price-icon i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-price-item.price-active .price-top-content .price-icon i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name' => 'pricebox_header_hover_background',
        'types' => ['classic', 'gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-price-item .price-top-content::before',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'pricebox_header_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-top-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator' => 'before',
      ]
    );
    $this->add_responsive_control(
      'pricebox_header_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-top-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-price-item .price-top-content .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item .price-top-content .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-top-content .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-top-content .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Price
    $this->start_controls_section(
      '_style_price',
      [
        'label' => esc_html__('Price', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_price_typography',
        'selector' => '{{WRAPPER}} .tj-price-item .price-top-content .price',
      ]
    );
    $this->add_control(
      'tj_price_color',
      [
        'label'     => __('Price Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item .price-top-content .price' => 'color: {{VALUE}}',
        ],
        'separator' => 'after',
      ]
    );
    $this->add_responsive_control(
      'tj_price_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-top-content .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_price_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-top-content .price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // feature
    $this->start_controls_section(
      '_style_feature',
      [
        'label' => esc_html__('Feature', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_feature_typography',
        'selector' => '{{WRAPPER}} .tj-price-item .price-bottom-content .price-list ul li',
      ]
    );
    $this->add_control(
      'tj_feature_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item .price-bottom-content .price-list ul li' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_feature_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item .price-bottom-content .price-list ul li i' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_feature_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-bottom-content .price-list ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_feature_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-bottom-content .price-list ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // button
    $this->start_controls_section(
      'section_tab_button',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typo',
        'label'    => esc_html__('Typography', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn',
      ]
    );
    $this->start_controls_tabs('style_tabs_1');
    $this->start_controls_tab(
      'btn_1_button_style_normal',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'btn_1_label_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_1_bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'btn_border',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'btn_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn',
      ]
    );
    $this->end_controls_tab();
    $this->start_controls_tab(
      'btn_1_button_style_hover',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_responsive_control(
      'btn_label_hover_color',
      [
        'label'     => esc_html__('Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'btn_hover__bg',
        'label'    => esc_html__('Background', 'tjcore'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn:before',
      ]
    );
    $this->add_group_control(
      Group_Control_Border::get_type(),
      [
        'name'     => 'btn_hover_border',
        'label'    => esc_html__('Border', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn:hover',
      ]
    );
    $this->add_group_control(
      Group_Control_Box_Shadow::get_type(),
      [
        'name'     => 'btn_hover_box_shadow',
        'label'    => esc_html__('Box Shadow', 'tjcore'),
        'selector' => '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn:hover',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();
    $this->add_responsive_control(
      'tj_btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'tj_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-price-item .price-button .tj-black-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  private static function get_currency_symbol($symbol_name) {
    $symbols = [
      'baht'         => '&#3647;',
      'bdt'          => '&#2547;',
      'dollar'       => '&#36;',
      'euro'         => '&#128;',
      'franc'        => '&#8355;',
      'guilder'      => '&fnof;',
      'indian_rupee' => '&#8377;',
      'pound'        => '&#163;',
      'peso'         => '&#8369;',
      'peseta'       => '&#8359',
      'lira'         => '&#8356;',
      'ruble'        => '&#8381;',
      'shekel'       => '&#8362;',
      'rupee'        => '&#8360;',
      'real'         => 'R$',
      'krona'        => 'kr',
      'won'          => '&#8361;',
      'yen'          => '&#165;',
    ];

    return isset($symbols[$symbol_name]) ? $symbols[$symbol_name] : '';
  }

  /**
   * Render the widget output on the frontend.
   *
   */
  protected function render() {
    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/pricing-box/style-' . $tj_design_style . '.php';
?>

<?php
  }
}

$widgets_manager->register(new TJ_Pricing_Box());
