<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for About.
 */
class TJ_Section_Title extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-section-title';
  }

  // widget title.
  public function get_title() {
    return __('TJ Section Heading', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-site-title tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'title',
      'section title',
      'tj title',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {
    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Section Heading Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Section Heading Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
          7 => esc_html__('Style 07', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // tj_section_title
    $this->start_controls_section(
      'tj_section_title',
      [
        'label' => esc_html__('Section Title', 'tjcore'),
      ]
    );
    $this->add_control(
      'tj_subtitle',
      [
        'label'       => esc_html__('Subtitle', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Section Subtitle', 'tjcore'),
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_subtitle_animation',
      [
        'label'        => esc_html__('Enable Subtitle Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_subtitle_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_subtitle_animation' => 'yes',
        ],
      ]
    );

    $this->add_control(
      'tj_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'type'      => Controls_Manager::TEXTAREA,
        'default'   => esc_html__('Section Title', 'tjcore'),
        'rows'      => '3',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_title_animation',
      [
        'label'        => esc_html__('Enable Title Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_title_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_title_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_title_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'is_content',
      [
        'label'        => esc_html__('Is Section Content?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator'    => 'before',
      ]
    );
    $this->add_control(
      'tj_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'type'      => Controls_Manager::WYSIWYG,
        'condition' => [
          'is_content' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_content_animation',
      [
        'label'        => esc_html__('Enable Content Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'condition'    => [
          'is_content' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_content_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'is_content'           => 'yes',
          'tj_content_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_content_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'is_content'           => 'yes',
          'tj_content_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_title_tag',
      [
        'label'   => esc_html__('Title HTML Tag', 'tjcore'),
        'type'    => Controls_Manager::CHOOSE,
        'options' => [
          'h1' => [
            'title' => esc_html__('H1', 'tjcore'),
            'icon'  => 'eicon-editor-h1',
          ],
          'h2' => [
            'title' => esc_html__('H2', 'tjcore'),
            'icon'  => 'eicon-editor-h2',
          ],
          'h3' => [
            'title' => esc_html__('H3', 'tjcore'),
            'icon'  => 'eicon-editor-h3',
          ],
          'h4' => [
            'title' => esc_html__('H4', 'tjcore'),
            'icon'  => 'eicon-editor-h4',
          ],
          'h5' => [
            'title' => esc_html__('H5', 'tjcore'),
            'icon'  => 'eicon-editor-h5',
          ],
          'h6' => [
            'title' => esc_html__('H6', 'tjcore'),
            'icon'  => 'eicon-editor-h6',
          ],
        ],
        'default' => 'h2',
        'toggle'  => false,
      ]
    );
    $this->add_responsive_control(
      'tj_alignment',
      [
        'label'        => esc_html__('Alignment', 'tjcore'),
        'type'         => Controls_Manager::CHOOSE,
        'options'      => [
          'left'   => [
            'title' => esc_html__('Left', 'tjcore'),
            'icon'  => 'eicon-text-align-left',
          ],
          'center' => [
            'title' => esc_html__('Center', 'tjcore'),
            'icon'  => 'eicon-text-align-center',
          ],
          'right'  => [
            'title' => esc_html__('Right', 'tjcore'),
            'icon'  => 'eicon-text-align-right',
          ],
        ],
        'default'      => 'left',
        'prefix_class' => 'tj_section_align elementor%s-align-',
        'separator'    => 'before',
        'condition' => [
          'tj_design_style' => ["1", "3", "5", "6"]
        ]
      ]
    );
    $this->end_controls_section();

    // tj_btn_button_group
    $this->start_controls_section(
      'tj_section_button_group',
      [
        'label' => esc_html__('Button', 'tjcore'),
        'condition' => [
          'tj_design_style' => ["1", "3", "6", '7']
        ]
      ]
    );
    $this->add_control(
      'tj_btn_button_show',
      [
        'label'        => esc_html__('Show Button', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Show', 'tjcore'),
        'label_off'    => esc_html__('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );

    $this->add_control(
      'tj_btn_text',
      [
        'label'       => esc_html__('Button Text', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Read More', 'tjcore'),
        'label_block' => true,
        'condition'   => [
          'tj_btn_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'       => esc_html__('Button Link Type', 'tjcore'),
        'type'        => Controls_Manager::SELECT,
        'options'     => [
          '1' => 'Custom Link',
          '2' => 'Internal Page',
        ],
        'default'     => '1',
        'label_block' => true,
        'condition'   => [
          'tj_btn_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'         => esc_html__('Button link', 'tjcore'),
        'type'          => Controls_Manager::URL,
        'dynamic'       => [
          'active' => true,
        ],
        'placeholder'   => esc_html__('https://your-link.com', 'tjcore'),
        'show_external' => false,
        'default'       => [
          'url'               => '#',
          'is_external'       => true,
          'nofollow'          => true,
          'custom_attributes' => '',
        ],
        'condition'     => [
          'tj_btn_link_type'   => '1',
          'tj_btn_button_show' => 'yes',
        ],
        'label_block'   => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Button Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_btn_link_type'   => '2',
          'tj_btn_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'btn_icon',
        'default'          => [
          'value'   => '',
          'library' => '',
        ],
        'skin'             => 'inline',
        'label_block'      => false,
        'condition'        => [
          'tj_btn_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_btn_id',
      [
        'label'       => esc_html__('Button ID', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'dynamic'     => [
          'active' => true,
        ],
        'ai'          => [
          'active' => false,
        ],
        'default'     => '',
        'title'       => esc_html__('Add your custom id WITHOUT the Pound key. e.g: my-id', 'tjcore'),
        'description' => sprintf(
          esc_html__('Please make sure the ID is unique and not used elsewhere on the page this form is displayed. This field allows %1$sA-z 0-9%2$s & underscore chars without spaces.', 'tjcore'),
          '<code>',
          '</code>'
        ),
        'condition'   => [
          'tj_btn_button_show' => 'yes',
        ],
        'separator'   => 'before',
      ]
    );
    $this->add_control(
      'tj_button_animation',
      [
        'label'        => esc_html__('Enable Button Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator'    => 'before',
        'condition'    => [
          'tj_btn_button_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_btn_button_show'  => 'yes',
          'tj_button_animation' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_button_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_button_animation' => 'yes',
          'tj_btn_button_show'  => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'tj_sec_images',
      [
        'label' => esc_html__('Section Images', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style' => '3'
        ]
      ]
    );
    $this->add_control(
      'tj_sec_images_show',
      [
        'label'        => esc_html__('Show Images', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Show', 'tjcore'),
        'label_off'    => esc_html__('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_section_image_style',
      [
        'label'   => esc_html__('Section Image Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
        ],
        'default' => 1,
        'condition' => [
          'tj_sec_images_show' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_sec_image-1',
      [
        'label' => esc_html__('Section Image 1', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_sec_images_show' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_sec_image-2',
      [
        'label' => esc_html__('Section Image 2', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_sec_images_show' => 'yes',
          'tj_section_image_style!' => ['3']
        ]
      ]
    );
    $this->add_control(
      'tj_sec_image-3',
      [
        'label' => esc_html__('Section Image 3', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_sec_images_show' => 'yes',
          'tj_section_image_style!' => ['2', '3']
        ]
      ]
    );
    $this->add_control(
      'tj_sec_image-4',
      [
        'label' => esc_html__('Section Image 4', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_sec_images_show' => 'yes',
          'tj_section_image_style!' => ['2', '3']
        ]
      ]
    );
    $this->add_control(
      'tj_image_animation',
      [
        'label'        => esc_html__('Enable Animation?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
        'separator' => 'before',
        'condition' => [
          'tj_sec_images_show' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_image_animation_name',
      [
        'label'     => esc_html__('Animation Name', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'default'   => '',
        'options'   => [
          ''            => esc_html__('Default', 'tjcore'),
          'zoomIn'      => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight' => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'    => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_image_animation' => 'yes',
          'tj_sec_images_show' => 'yes'
        ],
      ]
    );
    $this->add_control(
      'tj_image_animation_delay',
      [
        'label'      => esc_html__('Animation Delay', 'tjcore'),
        'type'       => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range'      => [
          'px' => [
            'min'  => 0,
            'max'  => 3,
            'step' => .1,
          ],
        ],
        'default'    => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition'  => [
          'tj_image_animation' => 'yes',
          'tj_sec_images_show' => 'yes'
        ],
      ]
    );
    $this->end_controls_section();

    // shapes
    $this->start_controls_section(
      'tj_sec_shapes',
      [
        'label' => esc_html__('Section Shapes', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
        'condition' => [
          'tj_design_style' => '3'
        ]
      ]
    );
    $this->add_control(
      'tj_sec_shapes_show',
      [
        'label'        => esc_html__('Show Shapes', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Show', 'tjcore'),
        'label_off'    => esc_html__('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'yes',
      ]
    );
    $this->add_control(
      'tj_sec_shape-1',
      [
        'label' => esc_html__('Section Shape 1', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'condition' => [
          'tj_sec_shapes_show' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_sec_shape-2',
      [
        'label' => esc_html__('Section Shape 2', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'condition' => [
          'tj_sec_shapes_show' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_sec_shape-3',
      [
        'label' => esc_html__('Section Shape 3', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'condition' => [
          'tj_sec_shapes_show' => 'yes',
          'tj_section_image_style!' => ['3']
        ]
      ]
    );
    $this->add_control(
      'tj_sec_shape-4',
      [
        'label' => esc_html__('Section Shape 4', 'tjcore'),
        'type' => Controls_Manager::MEDIA,
        'condition' => [
          'tj_sec_shapes_show' => 'yes',
          'tj_section_image_style!' => ['3']
        ]
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .tj-sec-heading',
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sec-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sec-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // subtitle
    $this->start_controls_section(
      '_style_subtitle',
      [
        'label' => esc_html__('Subtitle', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_subtitle_typography',
        'selector' => '{{WRAPPER}} .tj-sec-heading .sub-title, {{WRAPPER}} .tj-sec-heading.style-6 .subtitle, {{WRAPPER}} .tj-sec-heading.style-7 .subtitle',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Text Color', 'tjcore')
          ],
        ],
        'name' => 'tj_subtitle_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-sec-heading .sub-title',
        'condition' => [
          'tj_design_style!' => ['4', '5', '6']
        ]
      ]
    );
    $this->add_control(
      'tj_subtitle_solid_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sec-heading.style-6 .subtitle' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-sec-heading.style-7 .subtitle' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-sec-heading .sub-title' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['4', '5', '6']
        ]
      ]
    );
    $this->add_control(
      'tj_subtitle_dot_color',
      [
        'label'     => __('Dot Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sec-heading .sub-title::before' => 'background-color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['6']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sec-heading .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading.style-6 .subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading.style-7 .subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_subtitle_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sec-heading .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading.style-6 .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading.style-7 .subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label' => esc_html__('Title', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-sec-heading .sec-title, {{WRAPPER}} .tj-sec-heading .title',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sec-heading .sec-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-sec-heading .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'tj_title_span_color',
      [
        'label'     => __('Span Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sec-heading .title span' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['6']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Title Gradient', 'tjcore'),
          ],
        ],
        'name' => 'tj_title_gradient_color',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-sec-heading .sec-title span',
        'condition' => [
          'tj_design_style!' => ['4', '5', '6']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sec-heading .sec-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading.style-6 .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading.style-7 .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sec-heading .sec-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading.style-6 .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-sec-heading.style-7 .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // content
    $this->start_controls_section(
      '_style_content',
      [
        'label'     => esc_html__('Content', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'is_content' => 'yes',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_content_typography',
        'selector' => '{{WRAPPER}} .tj-sec-heading .desc',
      ]
    );
    $this->add_control(
      'tj_content_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-sec-heading .desc' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sec-heading .desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_content_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-sec-heading .desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // Section button
    $this->start_controls_section(
      '_heading_section_btn',
      [
        'label'     => __('Button', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_btn_button_show' => "yes",
          'tj_design_style' => ["1", "3", "6", "7"]
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_section_typography',
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border, {{WRAPPER}} .tj-black-btn-three',
      ]
    );
    $this->start_controls_tabs(
      'btn_section_tabs'
    );
    $this->start_controls_tab(
      'section_btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'section_btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}}  .tj-secondary-btn.btn-border span' => 'color: {{VALUE}}',
          '{{WRAPPER}}  .tj-black-btn-three' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Background Color', 'tjcore'),
          ],
        ],
        'name' => 'section_btn_background_color',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border span, {{WRAPPER}} .tj-black-btn-three',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Border Color', 'tjcore'),
          ],
        ],
        'name' => 'section_btn_border_color',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border, {{WRAPPER}} .tj-black-btn-three',
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_hover_section_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'section_btn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}}  .tj-secondary-btn.btn-border:hover span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-three:hover' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Background Color', 'tjcore'),
          ],
        ],
        'name' => 'section_btn_background_hover_color',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border:hover span, {{WRAPPER}} .tj-black-btn-three:after',
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Border Color', 'tjcore'),
          ],
        ],
        'name' => 'section_btn_border_hover_color',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border:hover, {{WRAPPER}} .tj-black-btn-three',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'section_btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}}  .tj-secondary-btn.btn-border span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}}  .tj-secondary-btn.btn-border' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}}  .tj-black-btn-three' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'section_btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}}  .tj-secondary-btn.btn-border span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'section_btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}}  .sec-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/sec-title/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Section_Title());
