<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Teams Layout.
 */
class TJ_Teams extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-teams';
  }

  // widget title.
  public function get_title() {
    return __('TJ Teams', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-person tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'teams',
      'team',
      'tj team',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {

    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Teams Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Teams Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
          6 => esc_html__('Style 06', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // Team Query
    $this->start_controls_section(
      'tj_team_query',
      [
        'label' => esc_html__('Team Query', 'tjcore'),
      ]
    );
    $post_type = 'teams';
    $this->add_control(
      'posts_per_page',
      [
        'label'       => esc_html__('Teams Per Page', 'tjcore'),
        'description' => esc_html__('Leave blank or enter -1 for all.', 'tjcore'),
        'type'        => Controls_Manager::NUMBER,
        'default'     => '4',
      ]
    );
    $this->add_control(
      'post__in',
      [
        'label'       => esc_html__('Include Member', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'post__not_in',
      [
        'label'       => esc_html__('Exclude Member', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'options'     => tj_get_all_types_post($post_type),
        'multiple'    => true,
        'label_block' => true,
      ]
    );
    $this->add_control(
      'offset',
      [
        'label'   => esc_html__('Offset', 'tjcore'),
        'type'    => Controls_Manager::NUMBER,
        'default' => '0',
      ]
    );
    $this->add_control(
      'orderby',
      [
        'label'   => esc_html__('Order By', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => array(
          'ID'            => 'Post ID',
          'author'        => 'Post Author',
          'title'         => 'Title',
          'date'          => 'Date',
          'modified'      => 'Last Modified Date',
          'parent'        => 'Parent Id',
          'rand'          => 'Random',
          'comment_count' => 'Comment Count',
          'menu_order'    => 'Menu Order',
        ),
        'default' => 'date',
      ]
    );
    $this->add_control(
      'order',
      [
        'label'   => esc_html__('Order', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          'asc'  => esc_html__('Ascending', 'tjcore'),
          'desc' => esc_html__('Descending', 'tjcore'),
        ],
        'default' => 'desc',

      ]
    );

    $this->add_control(
      'tj_view_all_teams',
      [
        'label'        => __('Show view all button?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => __('Show', 'tjcore'),
        'label_off'    => __('Hide', 'tjcore'),
        'return_value' => 'yes',
        'default'      => 'no',
        'separator' => 'before',
      ]
    );
    $this->add_control(
      'tj_viewall_button_text',
      [
        'label'     => __('Button Text', 'tjcore'),
        'type'      => Controls_Manager::TEXT,
        'default'   => esc_html__('View All', 'tjcore'),
        'dynamic'     => [
          'active' => true,
        ],
        'condition' => [
          'tj_view_all_teams' => "yes",
        ]
      ]
    );
    $this->add_control(
      'tj_btn_link_type',
      [
        'label'     => esc_html__('Link Type', 'tjcore'),
        'type'      => Controls_Manager::SELECT,
        'options'   => [
          '1' => esc_html__('Custom Link', 'tjcore'),
          '2' => esc_html__('Internal Page', 'tjcore'),
        ],
        'default'   => '1',
        'condition' => [
          'tj_view_all_teams' => "yes",
        ]
      ]
    );
    $this->add_control(
      'tj_btn_link',
      [
        'label'       => esc_html__('link', 'tjcore'),
        'type'        => Controls_Manager::URL,
        'dynamic'     => [
          'active' => true,
        ],
        'placeholder' => esc_html__('https://your-link.com', 'tjcore'),
        'default'     => [
          'url'               => '#',
          'is_external'       => false,
          'nofollow'          => false,
          'custom_attributes' => '',
        ],
        'condition'   => [
          'tj_view_all_teams' => "yes",
          'tj_btn_link_type' => '1',
        ],
        'label_block' => true,
      ]
    );
    $this->add_control(
      'tj_btn_page_link',
      [
        'label'       => esc_html__('Select Page', 'tjcore'),
        'type'        => Controls_Manager::SELECT2,
        'label_block' => true,
        'options'     => tj_get_all_pages(),
        'condition'   => [
          'tj_view_all_teams' => "yes",
          'tj_btn_link_type' => '2',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Overlay Color', 'tjcore')
          ],
        ],
        'name' => 'tj_overlay_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-team-item-two.style-8::before, {{WRAPPER}} .tj-team-item.style-9::after',
        'condition' => [
          'tj_design_style' => ['5', '6']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Content Background', 'tjcore')
          ],
        ],
        'name' => 'tj_content_box_bg',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-team-item .tj-team-content::after, {{WRAPPER}} .tj-team-item.style-9 .tj-team-content::after',
        'condition' => [
          'tj_design_style' => ['1', '6']
        ]
      ]
    );
    $this->add_control(
      'tj_socials_bg_color',
      [
        'label'     => __('Socials Background', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-team-content .team_socials' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-team-content .team-share' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['1', '5', '6']
        ]
      ]
    );
    $this->add_control(
      'tj_socials_icon_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-team-content .team-share ul li a' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-team-content .team_socials a' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['1', '5', '6']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'selector' => '{{WRAPPER}} .tj-team-item .tj-team-content::after, {{WRAPPER}} .tj_team_item.style-6 .team_content',
        'condition' => [
          'tj_design_style!' => ['1', '5', '6']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-team-item .tj-team-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_team_item.style-6 .team_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ['5', '6']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-team-item .tj-team-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_team_item.style-6 .team_content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ['5', '6']
        ]
      ]
    );
    $this->end_controls_section();

    // name
    $this->start_controls_section(
      '_style_name',
      [
        'label' => esc_html__('Name', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_name_typography',
        'selector' => '{{WRAPPER}} .tj-team-content .team-header .title-link, {{WRAPPER}} .tj_team_item.style-6 .team_content .name',
      ]
    );
    $this->add_control(
      'tj_name_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-team-content .team-header .title-link' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj_team_item.style-6 .team_content .name' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_name_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-team-content .team-header .title-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_team_item.style-6 .team_content .name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_name_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-team-content .team-header .title-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_team_item.style-6 .team_content .name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // designation
    $this->start_controls_section(
      '_style_designation',
      [
        'label' => esc_html__('Designation', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_designation_typography',
        'selector' => '{{WRAPPER}} .team-item .team-content .member-prof, {{WRAPPER}} .tj_team_item.style-6 .team_content .designation, {{WRAPPER}} .tj-team-content .team-header .sub-title',
      ]
    );
    $this->add_control(
      'tj_designation_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-team-item .tj-team-content .team-header .sub-title' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj_team_item.style-6 .team_content .designation' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-team-content .team-header .sub-title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_designation_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-team-item .tj-team-content .team-header .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_team_item.style-6 .team_content .designation' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-team-content .team-header .sub-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_designation_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-team-item .tj-team-content .team-header .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj_team_item.style-6 .team_content .designation' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-team-content .team-header .sub-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();


    // view all button
    $this->start_controls_section(
      '_view_all_btn',
      [
        'label'     => __('View All Button', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_view_all_teams' => "yes",
        ]

      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'btn_typography',
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border, {{WRAPPER}} .tj-black-btn-three',
      ]
    );
    $this->start_controls_tabs(
      'btn_tabs'
    );
    $this->start_controls_tab(
      'btn_normal_tab',
      [
        'label' => esc_html__('Normal', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-three' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'btn_background_color',
      [
        'label'     => esc_html__('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border span' => 'background: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-three' => 'background: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_tab();

    $this->start_controls_tab(
      'style_hover_tab',
      [
        'label' => esc_html__('Hover', 'tjcore'),
      ]
    );
    $this->add_control(
      'btn_text_hover_color',
      [
        'label'     => esc_html__('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border:hover span' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-black-btn-three' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Background Color', 'tjcore')
          ],
        ],
        'name' => 'btn_background_hover_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-secondary-btn.btn-border, {{WRAPPER}} .tj-secondary-btn.btn-border:hover span, {{WRAPPER}} .tj-black-btn-three::after',
      ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

    $this->add_responsive_control(
      'btn_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-secondary-btn.btn-border span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-three' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'btn_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .tj-secondary-btn.btn-border span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-black-btn-three' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'separator'  => 'before',
      ]
    );
    $this->add_responsive_control(
      'btn_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem', 'custom'],
        'selectors'  => [
          '{{WRAPPER}} .team-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/teams/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Teams());
