<?php

namespace TJCore;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;

if (!defined('ABSPATH')) {
  exit;
}
// Exit if accessed directly

/**
 * Elementor widget for Video.
 */
class TJ_Video extends Widget_Base {

  // widget name
  public function get_name() {
    return 'tj-video';
  }

  // widget title.
  public function get_title() {
    return __('TJ Video', 'tjcore');
  }

  // widget icon.
  public function get_icon() {
    return 'eicon-video-playlist tj-icon';
  }

  // Widget categories.
  public function get_categories() {
    return ['tjcore'];
  }

  // scripts dependencies.
  public function get_script_depends() {
    return ['tjcore-script'];
  }

  // styles dependencies.
  public function get_style_depends() {
    return ['tjcore-style'];
  }

  // Widget keywords.
  public function get_keywords() {
    return [
      'video',
      'videos',
      'tj video',
      'tj',
      'tj addons',
      'tjcore',
    ];
  }

  // Widget help url.
  public function get_custom_help_url() {
    return 'https://go.elementor.com/';
  }

  /**
   * widget controls.
   */
  protected function register_controls() {


    // layout Panel
    $this->start_controls_section(
      'tj_design_tab',
      [
        'label' => esc_html__('Video Style', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_design_style',
      [
        'label'   => esc_html__('Select Video Style', 'tjcore'),
        'type'    => Controls_Manager::SELECT,
        'options' => [
          1 => esc_html__('Style 01', 'tjcore'),
          2 => esc_html__('Style 02', 'tjcore'),
          3 => esc_html__('Style 03', 'tjcore'),
          4 => esc_html__('Style 04', 'tjcore'),
          5 => esc_html__('Style 05', 'tjcore'),
        ],
        'default' => 1,
      ]
    );
    $this->end_controls_section();

    // _tj_video_content
    $this->start_controls_section(
      '_tj_video_content',
      [
        'label' => esc_html__('Content', 'tjcore'),
        'tab'   => Controls_Manager::TAB_CONTENT,
      ]
    );
    $this->add_control(
      'tj_video_image',
      [
        'label'   => esc_html__('Upload Image', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'default' => [
          'url' => Utils::get_placeholder_image_src(),
        ],
        'condition' => [
          'tj_design_style!' => ["3", '5']
        ]
      ]
    );
    $this->add_control(
      'tj_video_image_overlay',
      [
        'label' => esc_html__('Image Overlay', 'tjcore'),
        'type' => Controls_Manager::COLOR,
        'default' => 'rgba(0, 0, 0, 0);',
        'selectors' => [
          '{{WRAPPER}} .video-image::after' => 'background-color: {{VALUE}}',
          '{{WRAPPER}} .tj-video-section::after' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ["3", '5']
        ]
      ]
    );
    $this->add_control(
      'tj_video_title',
      [
        'label'       => esc_html__('Title', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_html__('Video Presentation', 'tjcore'),
        'label_block' => 'true',
        'condition' => [
          'tj_design_style' => ["3", "4", "5"]
        ]
      ]
    );
    $this->add_control(
      'tj_video_link',
      [
        'label'       => esc_html__('Video Link', 'tjcore'),
        'type'        => Controls_Manager::TEXT,
        'default'     => esc_url('https://www.youtube.com/watch?v=E1xkXZs0cAQ'),
        'label_block' => 'true',
      ]
    );
    $this->add_control(
      'tj_video_icon',
      [
        'label'            => esc_html__('Icon', 'tjcore'),
        'type'             => Controls_Manager::ICONS,
        'fa4compatibility' => 'video_icon',
        'default'          => [
          'value' => 'fa-play',
          'library' => 'fa-solid',
        ],
      ]
    );

    $this->add_control(
      'tj_animation',
      [
        'label' => esc_html__('Enable Animation?', 'tjcore'),
        'type' => Controls_Manager::SWITCHER,
        'label_on' => esc_html__('Yes', 'tjcore'),
        'label_off' => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default' => '0',
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_animation_name',
      [
        'label' => esc_html__('Animation Name', 'tjcore'),
        'type' => Controls_Manager::SELECT,
        'default' => '',
        'options' => [
          '' => esc_html__('Default', 'tjcore'),
          'zoomIn' => esc_html__('Zoom In', 'tjcore'),
          'fadeInLeft'  => esc_html__('Fade In Left', 'tjcore'),
          'fadeInRight'  => esc_html__('Fade In Right', 'tjcore'),
          'fadeInUp'  => esc_html__('Fade In Up', 'tjcore'),
          'fadeInDown'  => esc_html__('Fade In Down', 'tjcore'),
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->add_control(
      'tj_animation_delay',
      [
        'label' => esc_html__('Animation Delay', 'tjcore'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px'],
        'range' => [
          'px' => [
            'min' => 0,
            'max' => 3,
            'step' => .1,
          ],
        ],
        'default' => [
          'unit' => 'px',
          'size' => 0.3,
        ],
        'condition' => [
          'tj_animation' => 'yes'
        ]
      ]
    );
    $this->end_controls_section();

    // tj_video_shape
    $this->start_controls_section(
      'tj_video_shape',
      [
        'label' => esc_html__('Video Shapes', 'tjcore'),
        'condition' => [
          'tj_design_style' => ["2"]
        ]
      ]
    );
    $this->add_control(
      'tj_shapes_show',
      [
        'label'        => esc_html__('Show video shapes?', 'tjcore'),
        'type'         => Controls_Manager::SWITCHER,
        'label_on'     => esc_html__('Yes', 'tjcore'),
        'label_off'    => esc_html__('No', 'tjcore'),
        'return_value' => 'yes',
        'default'      => '0',
      ]
    );
    $this->add_control(
      'tj_video_shape_1',
      [
        'label'   => esc_html__('Video Shape 1', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_video_shape_2',
      [
        'label'   => esc_html__('Video Shape 2', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
        ],
      ]
    );
    $this->add_control(
      'tj_video_shape_3',
      [
        'label'   => esc_html__('Video Shape 3', 'tjcore'),
        'type'    => Controls_Manager::MEDIA,
        'condition' => [
          'tj_shapes_show' => 'yes',
        ],
      ]
    );
    $this->end_controls_section();

    /** ---------------------------------------------------------------
     * TAB_STYLE
     * -------------------------------------------------------------* */
    $this->start_controls_section(
      '_section_style_content',
      [
        'label' => esc_html__('Section', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'name'     => 'tj_section_background',
        'types' => ['classic', 'gradient', 'video'],
        'selector' => '{{WRAPPER}} .video-image, {{WRAPPER}} .tj-video-area, {{WRAPPER}} .tj-video-section',
      ]
    );
    $this->add_responsive_control(
      'tj_section_border_radius',
      [
        'label'      => esc_html__('Border Radius', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors'  => [
          '{{WRAPPER}} .video-image'  => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
          'tj_design_style!' => ["2", "3", "4"]
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_section_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .video-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-video-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-video-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_section_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .video-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-video-area' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-video-section' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();

    // video play
    $this->start_controls_section(
      '_section_style_play_btn',
      [
        'label' => esc_html__('Play Button', 'tjcore'),
        'tab'   => Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label'     => __('Gradient Background', 'tjcore'),
          ],
        ],
        'name' => 'tj_play_gradient_bg_color',
        'types' => ['gradient'],
        'exclude' => ['image'],
        'selector' => '{{WRAPPER}} .popup-videos-button',
        'condition' => [
          'tj_design_style' => ['1',]
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_play_background_color',
      [
        'label'     => __('Background Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-video-section .video-area .video-icon' => 'background: {{VALUE}}',
          '{{WRAPPER}} .popup-videos-button' => 'background: {{VALUE}}',
          '{{WRAPPER}} .video_content_wrap .video_icon::after' => 'background: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style' => ['2', '3', '4', '5']
        ],
        'separator' => 'before'
      ]
    );
    $this->add_control(
      'tj_play_btn_color',
      [
        'label'     => __('Icon Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .popup-videos-button' => 'color: {{VALUE}}',
          '{{WRAPPER}} .popup-videos-button > i' => 'color: {{VALUE}}',
          '{{WRAPPER}} .tj-video-section.style-6 .video_play' => 'color: {{VALUE}}',
        ],
        'separator' => 'before'
      ]
    );
    $this->end_controls_section();

    // title
    $this->start_controls_section(
      '_style_title',
      [
        'label'     => esc_html__('Title', 'tjcore'),
        'tab'       => Controls_Manager::TAB_STYLE,
        'condition' => [
          'tj_design_style' => ["3", "4", "5"]
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Typography::get_type(),
      [
        'name'     => 'tj_title_typography',
        'selector' => '{{WRAPPER}} .tj-video-area .video-text .title, {{WRAPPER}} .tj-video-section.style-6 .video_content_wrap .video_text',
      ]
    );
    $this->add_control(
      'tj_title_color',
      [
        'label'     => __('Text Color', 'tjcore'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
          '{{WRAPPER}} .tj-video-area .video-text .title' => 'color: {{VALUE}}',
        ],
        'condition' => [
          'tj_design_style!' => ['4']
        ]
      ]
    );
    $this->add_group_control(
      Group_Control_Background::get_type(),
      [
        'fields_options' => [
          'background' => [
            'label' => esc_html__('Text Color', 'tjcore')
          ],
        ],
        'name' => 'tj_title_gradient_color',
        'types' => ['gradient'],
        'selector' => '{{WRAPPER}} .tj-video-section.style-6 .video_content_wrap .video_text',
        'condition' => [
          'tj_design_style' => ['4']
        ]
      ]
    );
    $this->add_responsive_control(
      'tj_title_padding',
      [
        'label'      => esc_html__('Padding', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-video-area .video-text .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-video-section.style-6 .video_content_wrap .video_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->add_responsive_control(
      'tj_title_margin',
      [
        'label'      => esc_html__('Margin', 'tjcore'),
        'type'       => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em', 'rem'],
        'selectors'  => [
          '{{WRAPPER}} .tj-video-area .video-text .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          '{{WRAPPER}} .tj-video-section.style-6 .video_content_wrap .video_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );
    $this->end_controls_section();
  }

  /**
   * Render the widget output on the frontend.
   */
  protected function render() {

    $settings = $this->get_settings_for_display();

    $tj_design_style = (!empty($settings['tj_design_style']) && $settings['tj_design_style'] > 0) ? $settings['tj_design_style'] : 1;

    include dirname(__FILE__) . '/styles/video/style-' . $tj_design_style . '.php';
?>


<?php
  }

  protected function content_template() {
  }
}
$widgets_manager->register(new TJ_Video());
