<?php

/** 
 * The main template file
 *
 * @package  WordPress
 * @subpackage  tjcore
 */
get_header();

$showTeams = get_theme_mod('show_teams_item', -1);

$args = array(
  'post_type' => 'teams',
  'post_status' => 'publish',
  'posts_per_page' => $showTeams,
  'order' => 'DESC',
);

// The Query
$query = new \WP_Query($args);

// customizer
$teamsLayout = get_theme_mod('teams_layout', 'layout-1');
?>

<div class="tj-team-section page-padding">
  <div class="container">
    <?php if ($query->have_posts()) : ?>


      <?php if ('layout-3' == $teamsLayout) : ?>
        <div class="row justify-content-center">
          <?php
          $n = 0;

          while ($query->have_posts()) : $query->the_post();
            $n++;

            $designation = function_exists('get_field') ? get_field("designation", get_the_ID()) : '';
            $socials = function_exists('get_field') ? get_field("member_socials", get_the_ID()) : '';
          ?>
            <div class="col-xl-3 col-lg-4 col-md-6 col-12">
              <div class="tj-team-item team-style-four wow fadeInUp" data-wow-delay=".3s">

                <?php if (has_post_thumbnail()) : ?>
                  <div class="team-image">
                    <?php the_post_thumbnail('full'); ?>
                  </div>
                <?php endif; ?>

                <div class="tj-team-content">
                  <div class="team-header">
                    <h5 class="title-link">
                      <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h5>
                    <?php if (!empty($designation)) : ?>
                      <span class="sub-title"><?php echo esc_html__($designation, 'tjcore'); ?></span>
                    <?php endif; ?>

                  </div>

                  <?php if (!empty($socials)) : ?>
                    <div class="team-share">
                      <ul class="dot-style">
                        <?php foreach ($socials as $social) : ?>
                          <li>
                            <a href="<?php echo esc_url($social['social_link']); ?>">
                              <?php echo tj_kses($social['social_icon']); ?>
                            </a>
                          </li>
                        <?php endforeach; ?>
                      </ul>
                    </div>
                  <?php endif; ?>

                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>

      <?php elseif ('layout-2' == $teamsLayout) : ?>
        <div class="row justify-content-center">
          <?php
          $n = 0;

          while ($query->have_posts()) : $query->the_post();
            $n++;

            $designation = function_exists('get_field') ? get_field("designation", get_the_ID()) : '';
            $socials = function_exists('get_field') ? get_field("member_socials", get_the_ID()) : '';
          ?>
            <div class="col-lg-3 col-md-6 col-sm-6">
              <div class="tj-team-item-two wow fadeInUp" data-wow-delay=".3s">
                <?php if (has_post_thumbnail()) : ?>
                  <div class="team-image">
                    <?php the_post_thumbnail('full'); ?>
                  </div>
                <?php endif; ?>

                <div class="tj-team-content">

                  <?php if (!empty($socials)) : ?>
                    <div class="team-share">
                      <ul class="dot-style">
                        <?php foreach ($socials as $social) : ?>
                          <li>
                            <a href="<?php echo esc_url($social['social_link']); ?>">
                              <?php echo tj_kses($social['social_icon']); ?>
                            </a>
                          </li>
                        <?php endforeach; ?>
                      </ul>
                    </div>
                  <?php endif; ?>

                  <div class="team-header">
                    <h5 class="title-link">
                      <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h5>
                    <?php if (!empty($designation)) : ?>
                      <span class="sub-title"><?php echo esc_html__($designation, 'tjcore'); ?></span>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>

      <?php else : ?>
        <div class="row justify-content-center">
          <?php
          while ($query->have_posts()) : $query->the_post();

            $designation = function_exists('get_field') ? get_field("designation", get_the_ID()) : '';
            $socials = function_exists('get_field') ? get_field("member_socials", get_the_ID()) : '';

          ?>
            <div class="col-xl-3 col-md-4 col-sm-6">
              <div class="tj-team-item wow fadeInUp" data-wow-delay=".3s">

                <?php if (has_post_thumbnail()) : ?>
                  <div class="team-image">
                    <?php the_post_thumbnail('full'); ?>
                  </div>
                <?php endif; ?>

                <div class="tj-team-content">
                  <div class="team-header">
                    <h5 class="title-link">
                      <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h5>

                    <?php if (!empty($designation)) : ?>
                      <span class="sub-title"><?php echo esc_html__($designation, 'tjcore'); ?></span>
                    <?php endif; ?>
                  </div>

                  <?php if (!empty($socials)) : ?>
                    <div class="team-share">
                      <ul class="dot-style">
                        <?php foreach ($socials as $social) : ?>
                          <li>
                            <a href="<?php echo esc_url($social['social_link']); ?>">
                              <?php echo tj_kses($social['social_icon']); ?>
                            </a>
                          </li>
                        <?php endforeach; ?>
                      </ul>
                    </div>
                  <?php endif; ?>

                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>

        </div>
    <?php endif;
    else :
      printf("%s", esc_html__("No team member available", 'tjcore'));
    endif; ?>
  </div>
</div>


<?php get_footer(); ?>