<?php

/** 
 * This template for portfolios archive
 *
 * @package  WordPress
 * @subpackage  tjcore
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}


get_header();

$showPortfolios = get_theme_mod('show_portfolios_item', -1);

$category = get_queried_object();

$args = array(
  'post_type' => 'portfolios',
  'post_status' => 'publish',
  'posts_per_page' => $showPortfolios,
  'order' => 'DESC',
  'tax_query' => array(
    array(
      'taxonomy' => 'portfolios-cat',
      'field'    => 'id',
      'terms'    => $category->term_id,
    ),
  ),
);

// The Query
$query = new \WP_Query($args);

// customizer
$portfoliosLayout = get_theme_mod('portfolios_layout', 'layout-1');
?>

<section class="tj-portfolios-section page-padding">
  <div class="container">
    <?php if ($query->have_posts()) : ?>

      <?php if ('layout-3' == $portfoliosLayout) : ?>
        <div class="row justify-content-center">
          <?php while ($query->have_posts()) : $query->the_post();

            // post category print 
            $portfolio_cats = get_the_terms(get_the_ID(), 'portfolios-cat');
          ?>
            <div class="col-xl-4 col-md-6">
              <div class="tj-portfolio-item-two style-2 wow fadeInUp" data-wow-delay=".3s">

                <?php if (!empty(has_post_thumbnail())) : ?>
                  <div class="portfolio-image">
                    <?php the_post_thumbnail('portfolio_thumb'); ?>
                  </div>
                <?php endif; ?>

                <div class="portfolio-content">
                  <?php if (!empty($portfolio_cats[0]->name)) : ?>
                    <span class="sub-title"><a href="<?php print esc_url(get_category_link($portfolio_cats[0]->term_id)); ?>"><?php echo esc_html($portfolio_cats[0]->name); ?></a></span>
                  <?php endif; ?>

                  <h4 class="title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                  </h4>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>

      <?php elseif ('layout-2' == $portfoliosLayout) : ?>
        <div class="row justify-content-center">
          <?php while ($query->have_posts()) : $query->the_post();

            // post category echo 
            $portfolio_cats = get_the_terms(get_the_ID(), 'portfolios-cat');
          ?>
            <div class="col-xl-4 col-md-6">

              <div class="portfolio-single-item style-3 wow fadeInUp" data-wow-delay=".3s">
                <div class="portfolio-single">
                  <?php if (!empty(has_post_thumbnail())) : ?>
                    <div class="portfolio-image">
                      <?php the_post_thumbnail('portfolio_thumb'); ?>
                    </div>
                  <?php endif; ?>

                  <div class="portfolio-content">
                    <div class="portfolio-header">
                      <?php if (!empty($portfolio_cats[0]->name)) : ?>
                        <span class="sub-title"><a href="<?php echo esc_url(get_category_link($portfolio_cats[0]->term_id)); ?>"><?php echo esc_html($portfolio_cats[0]->name); ?></a></span>
                      <?php endif; ?>
                      <h3 class="title-link">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                      </h3>
                    </div>
                    <div class="portfolio-arrow">
                      <a href="<?php the_permalink(); ?>"><i class="flaticon-next"></i></a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>

        </div>

      <?php else : ?>
        <div class="row justify-content-center">
          <?php while ($query->have_posts()) : $query->the_post();

            // post category print 
            $portfolio_cats = get_the_terms(get_the_ID(), 'portfolios-cat');
          ?>
            <div class="col-xl-4 col-md-6">
              <div class="tj-portfolio-item-two wow fadeInUp" data-wow-delay=".3s">

                <?php if (!empty(has_post_thumbnail())) : ?>
                  <div class="portfolio-image">
                    <?php the_post_thumbnail('portfolio_thumb'); ?>
                  </div>
                <?php endif; ?>

                <div class="portfolio-content">
                  <?php if (!empty($portfolio_cats[0]->name)) : ?>
                    <span class="sub-title"><a href="<?php print esc_url(get_category_link($portfolio_cats[0]->term_id)); ?>"><?php echo esc_html($portfolio_cats[0]->name); ?></a></span>
                  <?php endif; ?>

                  <h4 class="title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                  </h4>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>
    <?php endif;
    else :
      printf("%s", esc_html__("No portfolio available", 'tjcore'));
    endif; ?>
  </div>
</section>

<?php get_footer(); ?>