<?php

/** 
 * This template for Services Category Archive
 *
 * @package  WordPress
 * @subpackage  tjcore
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}


get_header();

$showServices = get_theme_mod('show_services_item', -1);

$category = get_queried_object();

$args = array(
  'post_type' => 'services',
  'post_status' => 'publish',
  'posts_per_page' => $showServices,
  'order' => 'DESC',
  'tax_query' => array(
    array(
      'taxonomy' => 'services-cat',
      'field'    => 'id',
      'terms'    => $category->term_id,
    ),
  ),
);

// The Query
$query = new \WP_Query($args);

// customizer
$servicesLayout = get_theme_mod('services_layout', 'layout-1');
?>

<section class="tj-services-section page-padding">
  <div class="container">
    <?php if ($query->have_posts()) : ?>

      <?php if ('layout-3' == $servicesLayout) : ?>
        <div class="row justify-content-center">
          <?php
          $n = 0;
          while ($query->have_posts()) : $query->the_post();
            $n++;

            $serviceIconType = function_exists('get_field') ? get_field("service_icon_type", get_the_ID()) : '';
            $serviceIcon = function_exists('get_field') ? get_field("service_icon", get_the_ID()) : '';
            $serviceFontAwesomeIcon = function_exists('get_field') ? get_field("service_fontawesome_icon", get_the_ID()) : '';
            $serviceImageIcon = function_exists('get_field') ? get_field("service_image_icon", get_the_ID()) : '';

            // post category print 
            $service_cats = get_the_terms(get_the_ID(), 'services-cat');
          ?>
            <div class="col-xl-3 col-lg-4 col-md-6 text-center">
              <div class="tj-service-item-four text-center wow fadeInUp" data-wow-delay="0.3s">
                <div class="service-inner">

                  <?php if ('image-icon' == $serviceIconType) :

                    if (!empty($serviceImageIcon)) : ?>
                      <div class="service-icon">
                        <img src="<?php echo esc_url($serviceImageIcon['url']); ?>" alt="<?php echo esc_attr($serviceImageIcon['alt']); ?>">
                      </div>
                    <?php endif;

                  elseif ('fontawesome-icon' == $serviceIconType) :

                    if (!empty($serviceFontAwesomeIcon)) : ?>
                      <div class="service-icon">
                        <?php echo tj_kses($serviceFontAwesomeIcon); ?>
                      </div>
                    <?php endif;
                  else :

                    if (!empty($serviceIcon)) : ?>
                      <div class="service-icon">
                        <i class="<?php echo esc_attr($serviceIcon); ?>"></i>
                      </div>
                  <?php endif;
                  endif; ?>

                  <div class="service-content">
                    <h4 class="title-link">
                      <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h4>
                    <?php if (!empty(get_the_excerpt())) : ?>
                      <div class="desc">
                        <p><?php echo wp_trim_words(get_the_excerpt(), 22, '...'); ?></p>
                      </div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>

      <?php elseif ('layout-2' == $servicesLayout) : ?>

        <div class="row justify-content-center">
          <?php
          $n = 0;
          while ($query->have_posts()) : $query->the_post();
            $n++;

            $serviceIconType = function_exists('get_field') ? get_field("service_icon_type", get_the_ID()) : '';
            $serviceIcon = function_exists('get_field') ? get_field("service_icon", get_the_ID()) : '';
            $serviceFontAwesomeIcon = function_exists('get_field') ? get_field("service_fontawesome_icon", get_the_ID()) : '';
            $serviceImageIcon = function_exists('get_field') ? get_field("service_image_icon", get_the_ID()) : '';

            // post category print 
            $service_cats = get_the_terms(get_the_ID(), 'services-cat');
          ?>
            <div class="col-xl-3 col-lg-6 col-md-6 col-sm-6 service">
              <div class="tj-service-item-three text-center wow fadeInUp" data-wow-delay="0.3s">
                <div class=" service_item_three_inner">

                  <?php if ('image-icon' == $serviceIconType) :

                    if (!empty($serviceImageIcon)) : ?>
                      <div class="service-icon">
                        <img src="<?php echo esc_url($serviceImageIcon['url']); ?>" alt="<?php echo esc_attr($serviceImageIcon['alt']); ?>">
                      </div>
                    <?php endif;

                  elseif ('fontawesome-icon' == $serviceIconType) :

                    if (!empty($serviceFontAwesomeIcon)) : ?>
                      <div class="service-icon">
                        <?php echo tj_kses($serviceFontAwesomeIcon); ?>
                      </div>
                    <?php endif;
                  else :

                    if (!empty($serviceIcon)) : ?>
                      <div class="service-icon">
                        <i class="<?php echo esc_attr($serviceIcon); ?>"></i>
                      </div>
                  <?php endif;
                  endif; ?>

                  <h4 class="title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                  </h4>
                  <?php if (!empty(get_the_excerpt())) : ?>
                    <div class="desc">
                      <p><?php echo wp_trim_words(get_the_excerpt(), 17, '...'); ?></p>
                    </div>
                  <?php endif; ?>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>

      <?php else : ?>
        <div class="row justify-content-center">
          <?php
          $n = 0;
          while ($query->have_posts()) : $query->the_post();
            $n++;

            $serviceIconType = function_exists('get_field') ? get_field("service_icon_type", get_the_ID()) : '';
            $serviceIcon = function_exists('get_field') ? get_field("service_icon", get_the_ID()) : '';
            $serviceFontAwesomeIcon = function_exists('get_field') ? get_field("service_fontawesome_icon", get_the_ID()) : '';
            $serviceImageIcon = function_exists('get_field') ? get_field("service_image_icon", get_the_ID()) : '';
          ?>
            <div class="col-lg-3 col-md-6 col-sm-6">
              <div class="tj-service-item text-center wow fadeInUp" data-wow-delay="0.3s">
                <div class="service-inner">

                  <?php if ('image-icon' == $serviceIconType) :

                    if (!empty($serviceImageIcon)) : ?>
                      <div class="service-icon">
                        <img src="<?php echo esc_url($serviceImageIcon['url']); ?>" alt="<?php echo esc_attr($serviceImageIcon['alt']); ?>">
                      </div>
                    <?php endif;

                  elseif ('fontawesome-icon' == $serviceIconType) :

                    if (!empty($serviceFontAwesomeIcon)) : ?>
                      <div class="service-icon">
                        <?php echo tj_kses($serviceFontAwesomeIcon); ?>
                      </div>
                    <?php endif;
                  else :

                    if (!empty($serviceIcon)) : ?>
                      <div class="service-icon">
                        <i class="<?php echo esc_attr($serviceIcon); ?>"></i>
                      </div>
                  <?php endif;
                  endif; ?>

                  <div class="service-content">
                    <h4 class="title-link">
                      <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h4>

                    <?php if (!empty(get_the_excerpt())) : ?>
                      <p><?php echo wp_trim_words(get_the_excerpt(), 24, '...'); ?></p>
                    <?php endif; ?>

                  </div>
                </div>
              </div>
            </div>
          <?php endwhile;
          wp_reset_query(); ?>
        </div>
    <?php endif;
    else :
      printf("%s", esc_html__("No service available", 'tjcore'));
    endif; ?>
  </div>
</section>

<?php get_footer(); ?>