<?php

/**
 * TJ Contact Info Widget
 *
 *
 * @author 		Theme_Junction
 * @category 	Widgets
 * @package 	TJCore/Widgets
 * @version 	1.0.0
 * @extends 	WP_Widget
 */
if (!defined('ABSPATH')) {
	die('Direct access forbidden.');
}


/**
 * Adds tj_contact_info_widget
 */
add_action('widgets_init', 'tj_contact_info_widget');
function tj_contact_info_widget() {
	register_widget('tj_contact_info_widget');
}

/**
 * Class TJ_Category_Widgets
 */
class TJ_Contact_Info_Widget  extends WP_Widget {

	/**
	 * Widget Constructor
	 */
	public function __construct() {
		$widget_opt = array(
			'classname'     => 'tj_contact_info widget_contact_menu',
			'description'   => 'Contact info widget by Theme Junction'
		);
		parent::__construct('tj-contact-info', esc_html__('TJ Contact Info', 'tjcore'), $widget_opt);
	}


	/**
	 * Front-end display of widget.
	 */
	public function widget($args, $instance) {
		extract($args);
		extract($instance);


		echo $before_widget;

		if (!empty($title)) {
			echo $before_title . apply_filters('widget_title', $title) . $after_title;
		}
?>

		<div class="footer-menu">
			<ul>
				<?php if (!empty($phone_number)) :  ?>
					<li>
						<span><i class="fa-solid fa-phone-volume"></i></span>
						<a href="tel:<?php echo esc_attr($phone_number); ?>"><?php echo esc_html($phone_number); ?></a>
					</li>
				<?php endif;

				if (!empty($email)) : ?>
					<li>
						<span><i class="fa-sharp fa-regular fa-envelope"></i></span>
						<a href="mailto:<?php echo esc_attr($email); ?>"><?php echo esc_html($email); ?></a>
					</li>
				<?php endif;

				if (!empty($website)) : ?>
					<li>
						<span><i class="fa-solid fa-globe"></i></span>
						<a href="<?php echo esc_attr($website); ?>"><?php echo esc_html($website); ?></a>
					</li>
				<?php endif;

				if (!empty($address)) : ?>
					<li>
						<span><i class="fa-sharp fa-solid fa-location-dot"></i></span>
						<p><?php echo esc_html($address); ?></p>
					</li>
				<?php endif; ?>
			</ul>
		</div>
		<?php echo $after_widget; ?>
	<?php
	}


	/**
	 * Back-end widget form.
	 */
	public function form($instance) {
		$title  = isset($instance['title']) ? $instance['title'] : esc_html__('Get in touch', 'tjcore');
		$phone_number  = isset($instance['phone_number']) ? $instance['phone_number'] : '';
		$email  = isset($instance['email']) ? $instance['email'] : '';
		$website  = isset($instance['website']) ? $instance['website'] : '';
		$address  = isset($instance['address']) ? $instance['address'] : '';
	?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title', 'tjcore'); ?></label>
			<input type="text" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" class="widefat" value="<?php echo esc_attr($title); ?>">
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('phone_number')); ?>"><?php esc_html_e('Phone Number :', 'tjcore'); ?></label>
			<input type="text" id="<?php echo esc_attr($this->get_field_id('phone_number')); ?>" name="<?php echo esc_attr($this->get_field_name('phone_number')); ?>" class="widefat" value="<?php echo esc_attr($phone_number); ?>">
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('email')); ?>"><?php esc_html_e('Email :', 'tjcore'); ?></label>
			<input type="text" id="<?php echo esc_attr($this->get_field_id('email')); ?>" name="<?php echo esc_attr($this->get_field_name('email')); ?>" class="widefat" value="<?php echo esc_attr($email); ?>">
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('website')); ?>"><?php esc_html_e('Website :', 'tjcore'); ?></label>
			<input type="text" id="<?php echo esc_attr($this->get_field_id('website')); ?>" name="<?php echo esc_attr($this->get_field_name('website')); ?>" class="widefat" value="<?php echo esc_attr($website); ?>">
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id('address')); ?>"><?php esc_html_e('Address :', 'tjcore'); ?></label>
			<input type="text" id="<?php echo esc_attr($this->get_field_id('address')); ?>" name="<?php echo esc_attr($this->get_field_name('address')); ?>" class="widefat" value="<?php echo esc_attr($address); ?>">
		</p>

<?php
	}


	/**
	 * Sanitize widget form values as they are saved.
	 */
	public function update($new_instance, $old_instance) {
		$instance = [];
		$instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
		$instance['phone_number'] = (!empty($new_instance['phone_number'])) ? strip_tags($new_instance['phone_number']) : '';
		$instance['email'] = (!empty($new_instance['email'])) ? strip_tags($new_instance['email']) : '';
		$instance['website'] = (!empty($new_instance['website'])) ? strip_tags($new_instance['website']) : '';
		$instance['address'] = (!empty($new_instance['address'])) ? strip_tags($new_instance['address']) : '';

		return $instance;
	}
}
