<?php

/**
 * Widget API: TJ_Gallery_Widget class
 *
 * @package WordPress
 * @subpackage Widgets
 * @since 4.9.0
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}


/**
 * Adds TJ_Gallery_Widget
 */
add_action('widgets_init', 'TJ_Gallery_Widget');
function TJ_Gallery_Widget() {
  register_widget('TJ_Gallery_Widget');
}


/**
 * Class TJ_Gallery_Widget
 */
class TJ_Gallery_Widget extends WP_Widget {


  /**
   * Widget Constructor
   */
  public function __construct() {
    $widget_opt = array(
      'classname'     => 'tj_gallery_widget',
      'description'   => 'Gallery widget by Theme Junction'
    );
    parent::__construct('tj-gallery-widget', esc_html__('TJ Gallery Widget', 'tjcore'), $widget_opt);
  }


  /**
   * Front-end display of widget.
   */
  public function widget($args, $instance) {
    extract($args);
    extract($instance);


    echo $before_widget;

    if (!empty($title)) {
      echo $before_title . apply_filters('widget_title', $title) . $after_title;
    }
?>

    <div class="widget_gallery popup-gallery">
      <?php
      $image_ids_array = explode(',', $image_ids);

      foreach ($image_ids_array as $image_id) :
        $img_atts_full = wp_get_attachment_image_src($image_id, 'full');
        $img_atts_thumb = wp_get_attachment_image_src($image_id, 'thumbnail');

      ?>

        <a class="gallery-item" href="<?php echo esc_url($img_atts_full[0]); ?>" data-bg-image="<?php echo esc_url($img_atts_thumb[0]); ?>">
          <div class="gallery-icon">
            <i class="fa-regular fa-plus"></i>
          </div>
        </a>

      <?php endforeach; ?>
    </div>

  <?php
    echo $after_widget;
  }


  /**
   * Back-end widget form.
   */
  public function form($instance) {
    $title  = isset($instance['title']) ? $instance['title'] : '';
    $image_ids = !empty($instance['image_ids']) ? $instance['image_ids'] : '';

    // Widget form fields here
  ?>
    <p>
      <label for="title"><?php esc_html_e('Title:', 'tscore'); ?></label>
      <input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" value="<?php echo esc_attr($title); ?>">
    </p>

    <p>
      <label for="<?php echo $this->get_field_id('image_ids'); ?>"><?php echo esc_attr('Gallery Images:'); ?></label>

    <div class="custom-widget-images" style="display: flex;flex-wrap:wrap;gap:10px">
      <?php
      $image_ids_array = explode(',', $image_ids);
      foreach ($image_ids_array as $image_id) {
        $image_url = wp_get_attachment_url($image_id);
        echo '<img src="' . esc_url($image_url) . '" style="max-width: 120px; height: auto;" />';
      }
      ?>
    </div>

    <input class="widefat custom-widget-image-ids" id="<?php echo $this->get_field_id('image_ids'); ?>" name="<?php echo $this->get_field_name('image_ids'); ?>" type="hidden" value="<?php echo esc_attr($image_ids); ?>" />

    <button class="button custom_widget_image_upload " style="width:100%;margin-top:10px;border: 1px dashed #c3c4c7;padding: 9px 0;color: #2c3338;">Upload Images</button>

    </p>

<?php
  }


  /**
   * Sanitize widget form values as they are saved.
   */
  public function update($new_instance, $old_instance) {
    $instance = [];
    $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
    $instance['image_ids'] = (!empty($new_instance['image_ids'])) ? strip_tags($new_instance['image_ids']) : '';

    return $instance;
  }
}
