<?php

/**
 * TJ Info Widget
 *
 *
 * @author 		ThemeJunction 
 * @category 	Widgets
 * @package 	TJCore/Widgets
 * @version 	1.0.0
 */
if (!defined('ABSPATH')) {
  die('Direct access forbidden.');
}


/**
 * Adds TJ_Info_Widgets
 */
add_action('widgets_init', 'TJ_Info_Widgets');
function TJ_Info_Widgets() {
  register_widget('TJ_Info_Widgets');
}

/**
 * Class TJ_Info_Widgets
 */
class TJ_Info_Widgets  extends WP_Widget {

  /**
   * Widget Constructor
   */
  public function __construct() {
    $widget_opt = array(
      'classname'     => 'tj_widget_info',
      'description'   => 'Info widgets by Theme Junction.'
    );
    parent::__construct('tj-info-widget', esc_html__('TJ Info Widget', 'tjcore'), $widget_opt);
  }


  /**
   * Front-end display of widget.
   */
  public function widget($args, $instance) {
    extract($args);
    extract($instance);


    echo $before_widget;

    if (!empty($title)) {
      echo $before_title . apply_filters('widget_title', $title) . $after_title;
    }
?>

    <div class="footer-content-info">

      <?php if (!empty($instance['logo_url'])) : ?>
        <div class="footer-logo">
          <a href="<?php echo esc_url(home_url('/')); ?>"><img src="<?php echo esc_url($instance['logo_url']); ?>" alt="<?php echo get_post_meta(attachment_url_to_postid($instance['logo_url']), '_wp_attachment_image_alt', true); ?>" /></a>
        </div>
      <?php endif; ?>

      <?php if (!empty($description)) : ?>
        <p><?php echo esc_html__($description, 'tjcore'); ?></p>
      <?php endif; ?>

      <?php if (!empty($facebook || $instagram || $twitter || $linkedin || $youtube)) : ?>
        <div class="footer-share">
          <ul class="dot-style">
            <?php if (!empty($facebook)) : ?>
              <li>
                <a href="<?php echo esc_url($facebook); ?>"><i class="fab fa-facebook-f"></i></a>
              </li>
            <?php endif; ?>

            <?php if (!empty($instagram)) : ?>
              <li>
                <a href="<?php echo esc_url($instagram); ?>"><i class="fab fa-instagram"></i></a>
              </li>
            <?php endif; ?>

            <?php if (!empty($twitter)) : ?>
              <li>
                <a href="<?php echo esc_url($twitter); ?>"><i class="fab fa-twitter"></i></a>
              </li>
            <?php endif; ?>

            <?php if (!empty($linkedin)) : ?>
              <li>
                <a href="<?php echo esc_url($linkedin); ?>"><i class="fab fa-linkedin-in"></i></a>
              </li>
            <?php endif; ?>

            <?php if (!empty($youtube)) : ?>
              <li>
                <a href="<?php echo esc_url($youtube); ?>"><i class="fab fa-youtube"></i></a>
              </li>
            <?php endif; ?>
          </ul>
        </div>
      <?php endif; ?>
    </div>
    <?php echo $after_widget; ?>
  <?php
  }


  /**
   * Back-end widget form.
   */
  public function form($instance) {

    $title  = isset($instance['title']) ? $instance['title'] : '';
    $description  = isset($instance['description']) ? $instance['description'] : '';
    $logo_url  = isset($instance['logo_url']) ? $instance['logo_url'] : '';

    $twitter  = isset($instance['twitter']) ? $instance['twitter'] : '';
    $facebook  = isset($instance['facebook']) ? $instance['facebook'] : '';
    $instagram  = isset($instance['instagram']) ? $instance['instagram'] : '';
    $youtube  = isset($instance['youtube']) ? $instance['youtube'] : '';
    $linkedin  = isset($instance['linkedin']) ? $instance['linkedin'] : '';

  ?>
    <!-- site logo -->
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('logo_url')); ?>"><?php esc_html_e('Site Logo', 'tjcore'); ?></label>
      <img class="<?php echo esc_attr($this->get_field_id('logo_url')); ?>_img" src="<?php echo (!empty($logo_url)) ? $logo_url : ''; ?>" style="margin:0;padding:0;max-width:100%;display:block" />
      <input type="hidden" class="widefat <?php echo esc_attr($this->get_field_id('logo_url')); ?>_url" name="<?php echo esc_attr($this->get_field_name('logo_url')); ?>" value="<?php echo esc_url($logo_url ?? ''); ?>" style="margin-top:5px;" />
      <input type="button" id="<?php echo esc_attr($this->get_field_id('logo_url')); ?>" class="widefat button widget-button js_custom_upload_media" value="Add Logo" style="margin-top:10px;border: 1px dashed #c3c4c7;padding: 9px 0;color: #2c3338;" />
    </p>

    <!-- description -->
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('description')); ?>"><?php esc_html_e('Short Description:', 'tjcore'); ?></label>
      <textarea class="widefat" rows="7" cols="15" id="<?php echo esc_attr($this->get_field_id('description')); ?>" value="<?php echo esc_attr($description); ?>" name="<?php echo esc_attr($this->get_field_name('description')); ?>"><?php echo esc_attr($description); ?></textarea>
    </p>

    <!-- facebook -->
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('facebook')); ?>"><?php esc_html_e('Facebook:', 'tjcore'); ?></label>
      <input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('facebook')); ?>" name="<?php echo esc_attr($this->get_field_name('facebook')); ?>" value="<?php echo esc_attr($facebook); ?>">
    </p>

    <!-- twitter -->
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('twitter')); ?>"><?php esc_html_e('Twitter:', 'tjcore'); ?></label>
      <input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('twitter')); ?>" name="<?php echo esc_attr($this->get_field_name('twitter')); ?>" value="<?php echo esc_attr($twitter); ?>">
    </p>

    <!-- instagram -->
    <p>
      <label class="widefat" for="<?php echo esc_attr($this->get_field_id('instagram')); ?>"><?php esc_html_e('Instagram:', 'tjcore'); ?></label>
      <input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('instagram')); ?>" name="<?php echo esc_attr($this->get_field_name('instagram')); ?>" value="<?php echo esc_attr($instagram); ?>">
    </p>

    <!-- linkedin -->
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('linkedin')); ?>"><?php esc_html_e('linkedin:', 'tjcore'); ?></label>
      <input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('linkedin')); ?>" name="<?php echo esc_attr($this->get_field_name('linkedin')); ?>" value="<?php echo esc_attr($linkedin); ?>">
    </p>

    <!-- youtube -->
    <p>
      <label for="<?php echo esc_attr($this->get_field_id('youtube')); ?>"><?php esc_html_e('Youtube:', 'tjcore'); ?></label>
      <input class="widefat" type="text" id="<?php echo esc_attr($this->get_field_id('youtube')); ?>" name="<?php echo esc_attr($this->get_field_name('youtube')); ?>" value="<?php echo esc_attr($youtube); ?>">
    </p>

<?php
  }


  /**
   * Sanitize widget form values as they are saved.
   */
  public function update($new_instance, $old_instance) {
    $instance = array();
    $instance['title'] = (!empty($new_instance['title'])) ? strip_tags($new_instance['title']) : '';
    $instance['description'] = (!empty($new_instance['description'])) ? strip_tags($new_instance['description']) : '';

    $instance['facebook'] = (!empty($new_instance['facebook'])) ? strip_tags($new_instance['facebook']) : '';
    $instance['twitter'] = (!empty($new_instance['twitter'])) ? strip_tags($new_instance['twitter']) : '';
    $instance['instagram'] = (!empty($new_instance['instagram'])) ? strip_tags($new_instance['instagram']) : '';
    $instance['youtube'] = (!empty($new_instance['youtube'])) ? strip_tags($new_instance['youtube']) : '';
    $instance['linkedin'] = (!empty($new_instance['linkedin'])) ? strip_tags($new_instance['linkedin']) : '';

    $instance['logo_url'] = (!empty($new_instance['logo_url'])) ? strip_tags($new_instance['logo_url']) : '';

    return $instance;
  }
}
