<?php

/**
 * TJ Plugin Validation Check
 *
 *
 * @author 		ThemeJunction 
 * @package 	TJCore
 * @version 	1.0.0
 * 
 * Class TJ_Core_Plugin
 */

namespace TJCore;

if (!defined('ABSPATH')) {
	die('Direct access forbidden.');
};



/** ---------------------------------------------------------------
 * Main Plugin class
 *---------------------------------------------------------------*/
class TJ_Core_Plugin {

	private static $_instance = null;

	public static function instance() {
		if (is_null(self::$_instance)) {
			self::$_instance = new self();
		}
		return self::$_instance;
	}

	/** ---------------------------------------------------------------
	 * Register Custom Category
	 *---------------------------------------------------------------*/
	public function tj_core_elementor_category($elements_manager) {
		$elements_manager->add_category(
			'tjcore',
			[
				'title' => esc_html__('ThemeJunction Widgets', 'tjcore'),
				'icon' => 'fa fa-plug',
			],
			1
		);
		$elements_manager->add_category(
			'tjcore-header',
			[
				'title' => esc_html__('ThemeJunction Header Widgets', 'tjcore'),
				'icon' => 'fa fa-plug',
			],
			1
		);
		$elements_manager->add_category(
			'tjcore-footer',
			[
				'title' => esc_html__('ThemeJunction Footer Widgets', 'tjcore'),
				'icon' => 'fa fa-plug',
			],
			1
		);
	}

	/** ---------------------------------------------------------------
	 * Register new Elementor widgets.
	 *---------------------------------------------------------------*/
	public function tj_register_widgets($widgets_manager) {
		// Its is now safe to include Widgets files
		foreach ($this->tjcore_widget_list() as $widget_file_name) {
			require_once(TJCORE_ELEMENTOR_PATH . "/{$widget_file_name}.php");
		}
	}

	public function tjcore_widget_list() {
		return [
			'tj-heading',
			'tj-text',
			'tj-button',
			'tj-image',
			'tj-page-header',
			'tj-sec-title',
			'tj-form',
			'tj-lists',
			'tj-latest-posts',

			'tj-icon-box',
			'tj-hero-banner',
			'tj-hero-slider',
			'tj-about-image',
			'tj-counter',
			'tj-testimonials',
			'tj-accordion',
			'tj-feature-box',
			'tj-cta',
			'tj-pricing-box',
			'tj-progress',
			'tj-animated-image',
			'tj-services',
			'tj-services-carousel',
			'tj-contact-info',
			'tj-navigation',
			'tj-video',
			'tj-teams',
			'tj-teams-carousel',
			'tj-info-list',
			'tj-socials',
			'tj-portfolios',
			'tj-portfolios-carousel',
			'tj-portfolio-info',
			'tj-marquee',
			'tj-skills',

			// header
			'tj-header',

			// footer
			'tj-footer-info',
			'tj-footer-contact-info',
			'tj-footer-nav',
			'tj-footer-gallery',
		];
	}

	// tjcore_widget_list_tutor
	public function tjcore_widget_list_tutor() {
		return [
			// 'tutor-course',
		];
	}

	/** ---------------------------------------------------------------
	 * TJ Custom Icons
	 *---------------------------------------------------------------*/
	public function tj_custom_icons_tab($tabs = []) {
		// font awesome light
		$tabs['fontawesome-light'] = [
			'name'          => 'fontawesome-light',
			'label'         => esc_html__('TJ Font Awesome - Light', 'tjcore'),
			'labelIcon'     => 'fab fa-font-awesome-alt',
			'prefix'        => 'fa-',
			'displayPrefix' => 'fal',
			'url'           => TJCORE_URL . './inc/icons/font-awesome/css/fontawesome-all.min.css',
			'fetchJson'     => TJCORE_URL . './inc/icons/font-awesome/fonts/font-awesome.json',
			'ver'           => '1.0.0',
		];

		// Flat Icons
		$tabs['tj-flaticons'] = [
			'name'          => 'tj-flaticons',
			'label'         => esc_html__('TJ Flaticons', 'tjcore'),
			'labelIcon'     => 'eicon-shape',
			'prefix'        => 'flaticon-',
			'displayPrefix' => 'tj flaticon',
			'url'           => TJCORE_URL . 'inc/icons/flaticon/css/flaticon_webency.css',
			'fetchJson'     => TJCORE_URL . 'inc/icons/flaticon/fonts/flaticon.json',
			'ver'           => '1.0.0',
		];

		return $tabs;
	}

	/** ---------------------------------------------------------------
	 * TJ Editor Enqueue Style
	 *---------------------------------------------------------------*/
	public function tj_editor_enqueue_styles() {
		wp_enqueue_style('tj-element-addons-editor', TJCORE_URL . 'assets/css/editor.css', null, '1.0');
	}

	/** ---------------------------------------------------------------
	 * TJ Editor Enqueue Scripts
	 *---------------------------------------------------------------*/
	public function tj_editor_enqueue_scripts() {
	}

	/** ---------------------------------------------------------------
	 * TJ Frontend Register Scripts
	 *---------------------------------------------------------------*/
	public function tj_frontend_register_scripts() {
	}

	/** ---------------------------------------------------------------
	 * TJ Frontend Enqueue Styles
	 *---------------------------------------------------------------*/
	public function tj_frontend_enqueue_styles() {
	}


	/** ---------------------------------------------------------------
	 * Force load editor script as a module
	 *---------------------------------------------------------------*/
	public function editor_scripts_as_a_module($tag, $handle) {
		if ('elementor-hello-world-editor' === $handle) {
			$tag = str_replace('<script', '<script type="module"', $tag);
		}

		return $tag;
	}

	/** ---------------------------------------------------------------
	 * Plugin class constructor
	 * Register plugin action hooks and filters
	 *---------------------------------------------------------------*/
	public function __construct() {
		// Register custom category
		add_action('elementor/elements/categories_registered', [$this, 'tj_core_elementor_category']);

		// Register Elementor New Widgets
		add_action('elementor/widgets/register', [$this, 'tj_register_widgets']);

		// Register custom icons
		add_filter('elementor/icons_manager/additional_tabs', [$this, 'tj_custom_icons_tab']);
		// $this->tj_custom_icons();

		// Enqueue Editor Scripts
		add_action('elementor/editor/after_enqueue_scripts', [$this, 'tj_editor_enqueue_scripts']);

		// Enqueue Editor Styles
		add_action('elementor/editor/before_enqueue_styles', [$this, 'tj_editor_enqueue_styles']);

		// Enqueue Frontend Scripts
		add_action('elementor/frontend/after_register_scripts', [$this, 'tj_frontend_register_scripts']);

		// Enqueue Frontend Styles
		add_action('elementor/frontend/before_enqueue_styles', [$this, 'tj_frontend_enqueue_styles']);
	}
}

// Instantiate Plugin Class
TJ_Core_Plugin::instance();
