<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

get_header();
?>
<section class="tj-error__area error-404 not-found">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-xxl-8  col-xl-8 2 col-lg-10 ">
				<?php
				$webency_error_title = get_theme_mod('webency_error_title', __('404', 'webency'));
				$webency_error_desc = get_theme_mod('webency_error_desc', __('Oops! The page you are looking for does not exist. It might have been moved or deleted.', 'webency'));
				$webency_error_link_text = get_theme_mod('webency_error_link_text', __('Back To Home', 'webency'));
				?>
				<div class="tj-error__wrap text-center">
					<div class="tj-error__content">
						<?php if (!empty($webency_error_title)) : ?>
							<h2 class="tj-error__title"><?php print esc_html($webency_error_title); ?></h2>
						<?php endif; ?>

						<?php if (!empty($webency_error_desc)) : ?>
							<p><?php print esc_html($webency_error_desc); ?></p>
						<?php endif; ?>

						<a href="<?php print esc_url(home_url('/')); ?>" class="tj-primary-btn"><?php print esc_html($webency_error_link_text); ?></a>
					</div>
				</div>
			</div>
		</div>
	</div>
</section><!-- .error-404 -->

<?php
get_footer();
