<?php

/**
 * Webency Theme functions and definitions.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

/**
 *---------------------------------------------------------------------------------------
 * Define constants
 *---------------------------------------------------------------------------------------
 */
define('WEBENCY_THEME_NAME', 'Webency');
define('WEBENCY_THEME_SLUG', 'webency');

define('WEBENCY_THEME_VERSION', '1.2.0');

define('WEBENCY_THEME_DIR', get_template_directory());
define('WEBENCY_THEME_URL', get_template_directory_uri());
define('WEBENCY_STYLESHEET_URL', get_stylesheet_uri());

define('WEBENCY_INC_DIR', WEBENCY_THEME_DIR . '/inc');
define('WEBENCY_INC_URL', WEBENCY_THEME_URL . '/inc');

define('WEBENCY_COMMON_DIR', WEBENCY_THEME_DIR . '/inc/common');
define('WEBENCY_COMMON_URL', WEBENCY_THEME_URL . '/inc/common');

define('WEBENCY_CUSTOMIZER_DIR', WEBENCY_INC_DIR . '/customizer/');

define('WEBENCY_TEMPLATE_PARTS', WEBENCY_THEME_DIR . '/template-parts/');

define('WEBENCY_ASSETS_DIR', WEBENCY_THEME_DIR . '/assets');
define('WEBENCY_ASSETS_URL', WEBENCY_THEME_URL . '/assets');

define('WEBENCY_ASSETS_CSS_DIR', WEBENCY_THEME_DIR . '/assets/css/');
define('WEBENCY_ASSETS_CSS_URL', WEBENCY_THEME_URL . '/assets/css/');

define('WEBENCY_ASSETS_JS_DIR', WEBENCY_THEME_DIR . '/assets/js/');
define('WEBENCY_ASSETS_JS_URL', WEBENCY_THEME_URL . '/assets/js/');

define('WEBENCY_ASSETS_IMAGES_DIR', WEBENCY_THEME_DIR . '/assets/images');
define('WEBENCY_ASSETS_IMAGES_URL', WEBENCY_THEME_URL . '/assets/images');

/**
 * ---------------------------------------------------------------------------------------
 * Template Hooks
 * ---------------------------------------------------------------------------------------
 */
require_once WEBENCY_INC_DIR . '/template-hooks.php';

/**
 * ---------------------------------------------------------------------------------------
 * Template Helpers
 * ---------------------------------------------------------------------------------------
 */
require_once WEBENCY_INC_DIR . '/template-helpers.php';

/**
 * ---------------------------------------------------------------------------------------
 * TGM Include
 * ---------------------------------------------------------------------------------------
 */
require_once WEBENCY_INC_DIR . '/lib/class-tgm-plugin-activation.php';
require_once WEBENCY_INC_DIR . '/lib/tgm-config.php';

/**
 * ---------------------------------------------------------------------------------------
 * Theme Customizer
 * ---------------------------------------------------------------------------------------
 */
require_once WEBENCY_INC_DIR . '/lib/class-kirki-customizer.php';
require_once WEBENCY_CUSTOMIZER_DIR . 'customizer-config.php';

/**
 * ---------------------------------------------------------------------------------------
 * Include Files
 * ---------------------------------------------------------------------------------------
 */
require_once WEBENCY_INC_DIR . '/template-functions.php';

require_once WEBENCY_INC_DIR . '/lib/class-navwalker.php';

if (defined('JETPACK__VERSION')) {
  require_once WEBENCY_INC_DIR . '/jetpack.php';
}
