<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<?php if (is_singular() && pings_open(get_queried_object())) : ?>
	<?php endif; ?>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>



<body <?php body_class(); ?>>

	<?php wp_body_open(); ?>

	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'webency'); ?></a>

	<!-- header start -->
	<?php do_action('webency_header_style'); ?>
	<!-- header end -->

	<!-- start: Before Main Content -->
	<?php do_action('webency_before_main_content'); ?>
	<!-- end: Before Main Content -->

	<!-- start: Breadcrumb Section -->
	<?php do_action('webency_breadcrumb'); ?>
	<!-- end: Breadcrumb Section -->

	<main id="content" class="site-main">