<?php

/**
 * Webency Theme Scripts
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}


function webency_scripts() {
  /**
   * ---------------------------------------------------------------------------------------
   * Enqueue All CSS Files
   * ---------------------------------------------------------------------------------------
   */
  wp_enqueue_style('webency-google-fonts', webency_google_fonts_url(), '', null);

  if (is_rtl()) {
    wp_enqueue_style('bootstrap-rtl', WEBENCY_ASSETS_CSS_URL . 'bootstrap.rtl.min.css', []);
  } else {
    wp_enqueue_style('bootstrap', WEBENCY_ASSETS_CSS_URL . 'bootstrap.min.css', []);
  }
  wp_enqueue_style('font-awesome-pro', WEBENCY_ASSETS_CSS_URL . 'font-awesome-pro.min.css', []);
  wp_enqueue_style('webency-flaticon', WEBENCY_ASSETS_CSS_URL . 'flaticon_webency.css', []);
  wp_enqueue_style('animate', WEBENCY_ASSETS_CSS_URL . 'animate.min.css', []);
  wp_enqueue_style('nice-select', WEBENCY_ASSETS_CSS_URL . 'nice-select.css', []);
  wp_enqueue_style('meanmenu', WEBENCY_ASSETS_CSS_URL . 'meanmenu.css', []);
  wp_enqueue_style('odometer', WEBENCY_ASSETS_CSS_URL . 'odometer.min.css', []);
  wp_enqueue_style('magnific-popup', WEBENCY_ASSETS_CSS_URL . 'magnific-popup.css', []);
  wp_enqueue_style('webency-swiper', WEBENCY_ASSETS_CSS_URL . 'swiper.min.css', []);
  wp_enqueue_style('owl-carousel', WEBENCY_ASSETS_CSS_URL . 'owl.carousel.min.css', []);
  wp_enqueue_style('webency-core', WEBENCY_ASSETS_CSS_URL . 'webency-core.css', [], WEBENCY_THEME_VERSION);
  wp_enqueue_style('webency-unit', WEBENCY_ASSETS_CSS_URL . 'webency-unit.css', [], WEBENCY_THEME_VERSION);
  wp_enqueue_style('webency-custom', WEBENCY_ASSETS_CSS_URL . 'webency-custom.css', [], WEBENCY_THEME_VERSION);

  wp_enqueue_style('webency-style', get_stylesheet_uri(), [], WEBENCY_THEME_VERSION);

  /**
   * ---------------------------------------------------------------------------------------
   * Enqueue All JS Files
   * ---------------------------------------------------------------------------------------
   */
  wp_enqueue_script('bootstrap-bundle', WEBENCY_ASSETS_JS_URL . 'bootstrap.bundle.min.js', ['jquery'], '', true);
  wp_enqueue_script('nice-select', WEBENCY_ASSETS_JS_URL . 'nice-select.js', ['jquery'], '', true);
  wp_enqueue_script('meanmenu', WEBENCY_ASSETS_JS_URL . 'meanmenu.js', ['jquery'], '', true);
  wp_enqueue_script('webency-swiper', WEBENCY_ASSETS_JS_URL . 'swiper.min.js', ['jquery'], '', true);
  wp_enqueue_script('owl-carousel', WEBENCY_ASSETS_JS_URL . 'owl.carousel.min.js', ['jquery'], '', true);
  wp_enqueue_script('appear', WEBENCY_ASSETS_JS_URL . 'appear.min.js', ['jquery'], '', true);
  wp_enqueue_script('wow', WEBENCY_ASSETS_JS_URL . 'wow.min.js', ['jquery'], '', true);
  wp_enqueue_script('odometer', WEBENCY_ASSETS_JS_URL . 'odometer.min.js', ['jquery'], '', true);
  wp_enqueue_script('magnific-popup', WEBENCY_ASSETS_JS_URL . 'magnific-popup.js', ['jquery'], '', true);
  wp_enqueue_script('isotope', WEBENCY_ASSETS_JS_URL . 'isotope.pkgd.min.js', ['imagesloaded'], '', true);
  wp_enqueue_script('webency-main', WEBENCY_ASSETS_JS_URL . 'main.js', ['jquery'], WEBENCY_THEME_VERSION, true);

  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }
}
add_action('wp_enqueue_scripts', 'webency_scripts');

/**
 * ---------------------------------------------------------------------------------------
 * Register Google Fonts
 * ---------------------------------------------------------------------------------------
 */
function webency_google_fonts_url() {
  $fonts_url     = '';
  $font_families = [];

  $BilboSwashCaps       = _x('on', 'Bilbo Swash Caps font: on or off', 'webency');
  $NunitoSans       = _x('on', 'Nunito Sans font: on or off', 'webency');
  $Ubuntu = _x('on', 'Ubuntu font: on or off', 'webency');

  if ('off' !== $BilboSwashCaps) {
    $font_families[] = 'Bilbo Swash Caps';
  }
  if ('off' !== $NunitoSans) {
    $font_families[] = 'Nunito Sans:ital,opsz,wght@0,300;0,400;0,500;0,600;0,700;0,800;1,300;1,400;1,500;1,600;1,700;1,800&display=swap';
  }
  if ('off' !== $Ubuntu) {
    $font_families[] = 'Ubuntu:ital,wght@0,300;0,400;0,500;0,700;1,300;1,400;1,500;1,700&display=swap';
  }

  if ($font_families) {
    $query_args = array(
      'family' => urlencode(implode('|', $font_families)),
      'subset' => urlencode('latin,latin-ext'),
    );
    $fonts_url = add_query_arg($query_args, '//fonts.googleapis.com/css');
  }

  return $fonts_url;
}
