<?php

/**
 * Webency Theme Widgets Register
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}

/**
 *    ---------------------------------------------------------------------------------------
 *    Register widget area.
 *    ---------------------------------------------------------------------------------------
 */

/**
 * blog sidebar
 */
register_sidebar([
  'name'          => esc_html__('Blog Sidebar', 'webency'),
  'id'            => 'blog-sidebar',
  'before_widget' => '<div id="%1$s" class="tj-sidebar__widget tj-blog-widget wow fadeInUp %2$s" data-wow-delay="0.4s">',
  'after_widget'  => '</div>',
  'before_title'  => '<h3 class="tj-sidebar-widget__title side-title">',
  'after_title'   => '</h3>',
]);

$footer_columns = get_theme_mod('footer_widget_column', 4);
$footer_style_2_switch = get_theme_mod('footer_style_2_switch', true);
$footer_style_3_switch = get_theme_mod('footer_style_3_switch', true);
$footer_style_4_switch = get_theme_mod('footer_style_4_switch', true);

// footer default
for ($num = 1; $num <= $footer_columns; $num++) {
  register_sidebar([
    'name'          => sprintf(esc_html__('Footer Column %1$s', 'webency'), $num),
    'id'            => 'footer-' . $num,
    'description'   => sprintf(esc_html__('This widget content will be show widget %1$s', 'webency'), $num),
    'before_widget' => '<div id="%1$s" class="tj-footer__widget footer-widget footer1-col-' . $num . ' %2$s">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="tj-footer-widget_title footer_title">',
    'after_title'   => '</h4>',
  ]);
}

// footer 2
if ($footer_style_2_switch) {
  for ($num = 1; $num <= $footer_columns; $num++) {

    register_sidebar([
      'name'          => sprintf(esc_html__('Footer Style 2 : Column %1$s', 'webency'), $num),
      'id'            => 'footer-2-' . $num,
      'description'   => sprintf(esc_html__('Footer Style 2 : Column %1$s Widgets', 'webency'), $num),
      'before_widget' => '<div id="%1$s" class="tj-footer__widget footer-widget footer2-col-' . $num . ' %2$s">',
      'after_widget'  => '</div>',
      'before_title'  => '<h4 class="tj-footer-widget_title footer_title">',
      'after_title'   => '</h4>',
    ]);
  }
}

// footer 3
if ($footer_style_3_switch) {
  for ($num = 1; $num <= $footer_columns; $num++) {

    register_sidebar([
      'name'          => sprintf(esc_html__('Footer Style 3 : Column %1$s', 'webency'), $num),
      'id'            => 'footer-3-' . $num,
      'description'   => sprintf(esc_html__('Footer Style 3 : Column %1$s Widgets', 'webency'), $num),
      'before_widget' => '<div id="%1$s" class="tj-footer__widget footer-widget footer3-col-' . $num . ' %2$s">',
      'after_widget'  => '</div>',
      'before_title'  => '<h4 class="tj-footer-widget_title footer_title">',
      'after_title'   => '</h4>',
    ]);
  }
}

// footer 4
if ($footer_style_4_switch) {
  for ($num = 1; $num <= $footer_columns; $num++) {

    register_sidebar([
      'name'          => sprintf(esc_html__('Footer Style 4 : Column %1$s', 'webency'), $num),
      'id'            => 'footer-4-' . $num,
      'description'   => sprintf(esc_html__('Footer Style 4 : Column %1$s Widgets', 'webency'), $num),
      'before_widget' => '<div id="%1$s" class="tj-footer__widget footer-widget footer4-col-' . $num . ' %2$s">',
      'after_widget'  => '</div>',
      'before_title'  => '<h4 class="tj-footer-widget_title footer_title">',
      'after_title'   => '</h4>',
    ]);
  }
}
