<?php

/**
 * Webency Customizer Configuration
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

if (!defined('ABSPATH')) {
  exit;
}

// Do not proceed if Kirki does not exist.
if (!class_exists('Kirki')) {
  return;
}

class Webency_Customizer {

  public static $_instance;

  public function __construct() {
    add_action('customize_register', [$this, 'webency_customizer_sections']);
    add_filter('kirki/fields', [$this, 'webency_customizer_setting']);
    add_action('customize_preview_init', [$this, 'webency_customize_preview_js']);
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Sections
   *    ---------------------------------------------------------------------------------------
   */
  public function webency_customizer_sections($wp_customize) {
    // Customizer Panel
    $wp_customize->add_panel('webency_customizer_panel', [
      'priority' => 10,
      'title'    => esc_html__('Webency Customizer', 'webency'),
    ]);

    // general settings
    $wp_customize->add_section('general_settings', [
      'title'       => esc_html__('General Settings', 'webency'),
      'priority'    => 1,
      'description' => esc_html__('To change site general settings and google map api.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // typography settings
    $wp_customize->add_section('typo_settings', [
      'title'       => esc_html__('Typography Settings', 'webency'),
      'priority'    => 2,
      'description' => esc_html__('Setup site typography settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // colors settings
    $wp_customize->add_section('colors_settings', [
      'title'       => esc_html__('Color Settings', 'webency'),
      'priority'    => 3,
      'description' => esc_html__('Setup site color settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // header settings
    $wp_customize->add_section('header_settings', [
      'title'       => esc_html__('Header Settings', 'webency'),
      'priority'    => 4,
      'description' => esc_html__('Setup site header settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // Logos
    $wp_customize->add_section('webency_theme_logos', [
      'title'       => esc_html__('Site Logos', 'webency'),
      'description' => esc_html__('Setup site logos.', 'webency'),
      'priority'    => 5,
      'capability'  => 'edit_theme_options',
      'panel'       => 'webency_customizer_panel',
    ]);

    // Header Top Bars
    $wp_customize->add_section('header_top_bar', [
      'title'       => esc_html__('Header Topbar', 'webency'),
      'priority'    => 6,
      'description' => esc_html__('Setup site header top bar settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // Header Sidebar
    $wp_customize->add_section('header_side_setting', [
      'title'       => esc_html__('Header Sidebar', 'webency'),
      'priority'    => 7,
      'description' => esc_html__('Setup site header sidebar settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // Contact Infos
    $wp_customize->add_section('webency_contact_infos', [
      'title'       => esc_html__('Contact Info', 'webency'),
      'description' => esc_html__('Setup site contact infos.', 'webency'),
      'priority'    => 8,
      'panel'       => 'webency_customizer_panel',
    ]);

    // mobile menu
    $wp_customize->add_section('webency_mobile_menu', [
      'title'       => esc_html__('Mobile Menu', 'webency'),
      'description' => esc_html__('Setup site mobile menu infos.', 'webency'),
      'priority'    => 9,
      'panel'       => 'webency_customizer_panel',
    ]);

    // Breadcrumb Settings
    $wp_customize->add_section('breadcrumb_setting', [
      'title'       => esc_html__('Breadcrumb Setting', 'webency'),
      'priority'    => 10,
      'description' => esc_html__('Setup site breadcrumb settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // blog settings
    $wp_customize->add_section('blog_settings', [
      'title'       => esc_html__('Blog Settings', 'webency'),
      'priority'    => 11,
      'description' => esc_html__('Setup blog pages settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // Services settings
    $wp_customize->add_section('services_settings', [
      'title'       => esc_html__('Services Settings', 'webency'),
      'priority'    => 12,
      'description' => esc_html__('Setup Services pages settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // Teams settings
    $wp_customize->add_section('teams_settings', [
      'title'       => esc_html__('Teams Settings', 'webency'),
      'priority'    => 13,
      'description' => esc_html__('Setup Teams pages settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // Portfolios settings
    $wp_customize->add_section('portfolios_settings', [
      'title'       => esc_html__('Portfolios Settings', 'webency'),
      'priority'    => 14,
      'description' => esc_html__('Setup portfolios pages settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // footer settings
    $wp_customize->add_section('footer_settings', [
      'title'       => esc_html__('Footer Settings', 'webency'),
      'priority'    => 15,
      'description' => esc_html__('Setup site footer settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // permalink settings
    $wp_customize->add_section('permalink_settings', [
      'title'       => esc_html__('Permalink Settings', 'webency'),
      'priority'    => 16,
      'description' => esc_html__('Setup site permalink settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);

    // 404 page settings
    $wp_customize->add_section('404_page', [
      'title'       => esc_html__('404 Page', 'webency'),
      'priority'    => 16,
      'description' => esc_html__('Setup 404 page settings.', 'webency'),
      'panel'       => 'webency_customizer_panel',
    ]);
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Settings Fields
   *    ---------------------------------------------------------------------------------------
   */
  public function webency_customizer_setting($fields) {

    require WEBENCY_CUSTOMIZER_DIR . 'fields/general-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/typography-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/colors-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/header-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/theme-logos.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/contact-infos.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/header-topbar.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/mobile-menu.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/breadcrumb-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/blog-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/services-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/teams-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/portfolios-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/footer-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/permalink-settings.php';
    require WEBENCY_CUSTOMIZER_DIR . 'fields/404-settings.php';

    return $fields;
  }

  /**
   *    ---------------------------------------------------------------------------------------
   *    Customizer Preview JS
   *    ---------------------------------------------------------------------------------------
   */
  public function webency_customize_preview_js() {
    wp_enqueue_script('webency-customizer', WEBENCY_INC_URL . '/assets/js/customize-preview.js', array('customize-preview'), WEBENCY_THEME_VERSION, true);
  }

  public static function webency_get_instance() {
    if (!isset(self::$_instance)) {
      self::$_instance = new Webency_Customizer();
    }
    return self::$_instance;
  }
}
$webency_Fields = Webency_Customizer::webency_get_instance();
