<?php

/**
 * Customizer Blog Settings
 *
 * style for theme blogs
 */

$fields[] = [
  'type'     => 'custom',
  'settings' => 'blog_custom_01',
  'label'    => FALSE,
  'section'  => 'blog_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Blog Page Settings', 'webency') . '</div>',
];
// breadcrumb title
$fields[] = [
  'type'     => 'text',
  'settings' => 'blog_breadcrumb_title',
  'label'    => esc_html__('Blog Breadcrumb Title', 'webency'),
  'section'  => 'blog_settings',
  'default'  => esc_html__('Blog', 'webency'),
  'priority' => 10,
];
// blog breadcrumb image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'blog_breadcrumb_img',
  'label'       => esc_html__('Blog Breadcrumb Image', 'webency'),
  'section'     => 'blog_settings',
];
// Blog button
$fields[] = [
  'type'     => 'switch',
  'settings' => 'webency_blog_btn_switch',
  'label'    => esc_html__('BTN On/Off', 'webency'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'priority' => 10,
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
];
// button text
$fields[] = [
  'type'     => 'text',
  'settings' => 'webency_blog_btn',
  'label'    => esc_html__('Button text', 'webency'),
  'section'  => 'blog_settings',
  'default'  => esc_html__('Read More', 'webency'),
  'priority' => 10,
  'active_callback' => [
    [
      'setting'  => 'webency_blog_btn_switch',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];

// author meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'webency_blog_author',
  'label'    => esc_html__('Author Meta On/Off', 'webency'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'priority' => 10,
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
];
// date meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'webency_blog_date',
  'label'    => esc_html__('Date Meta On/Off', 'webency'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'priority' => 10,
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
];
// comment meta
$fields[] = [
  'type'     => 'switch',
  'settings' => 'webency_blog_comments',
  'label'    => esc_html__('Comments Meta On/Off', 'webency'),
  'section'  => 'blog_settings',
  'default'  => '1',
  'priority' => 10,
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
];

// blog details
$fields[] = [
  'type'     => 'custom',
  'settings' => 'blog_custom_02',
  'label'    => FALSE,
  'section'  => 'blog_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Blog Details Page', 'webency') . '</div>',
];
// blog details breadcrumb title
$fields[] = [
  'type'     => 'text',
  'settings' => 'blog_details_breadcrumb_title',
  'label'    => esc_html__('Blog Details Breadcrumb Title', 'webency'),
  'section'  => 'blog_settings',
  'priority' => 10,
];
// blog details breadcrumb image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'blog_details_breadcrumb_img',
  'label'       => esc_html__('Blog Details Breadcrumb Image', 'webency'),
  'section'     => 'blog_settings',
];
// blog social share
$fields[] = [
  'type'     => 'switch',
  'settings' => 'webency_blog_social',
  'label'    => esc_html__('Blog Socials Share On/Off', 'webency'),
  'section'  => 'blog_settings',
  'default'  => '0',
  'priority' => 10,
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
];
