<?php

/**
 * Customizer Breadcrumb Settings
 *
 * style for theme breadcrumb style
 */

$fields[] = [
  'type'     => 'custom',
  'settings' => 'header_custom_01',
  'label'    => FALSE,
  'section'  => 'breadcrumb_setting',
  'default'  => '<div class="customizer_label">' . esc_html__('Breadcrumb Settings', 'webency') . '</div>',
];
// navigation info
$fields[] = [
  'type'     => 'switch',
  'settings' => 'show_breadcrumb',
  'label'    => esc_html__('Show breadcrumb?', 'webency'),
  'section'  => 'breadcrumb_setting',
  'default'  => '1',
  'priority' => 10,
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
];
// background image
$fields[] = [
  'type'        => 'image',
  'settings'    => 'breadcrumb_bg_img',
  'label'       => esc_html__('Background Image', 'webency'),
  'section'     => 'breadcrumb_setting',
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// background color
$fields[] = [
  'type'        => 'color',
  'settings'    => 'breadcrumb_bg_color',
  'label'       => __('Background Color', 'webency'),
  'section'     => 'breadcrumb_setting',
  'default'     => '#282828',
  'priority'    => 10,
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// background color
$fields[] = [
  'type'        => 'color',
  'settings'    => 'breadcrumb_bg_overlay_color',
  'label'       => __('Background Overlay Color', 'webency'),
  'section'     => 'breadcrumb_setting',
  'transport'   => 'auto',
  'choices'     => [
    'alpha' => true,
  ],
  'default'     => 'rgba(0, 0, 0, 0)',
  'output'      => [
    [
      'element'  => '.breadcrumb-wrapper::after',
      'property' => 'background-color',
    ],
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// navigation switcher
$fields[] = [
  'type'     => 'switch',
  'settings' => 'breadcrumb_navigation_switch',
  'label'    => esc_html__('Breadcrumb Navigation on/off?', 'webency'),
  'section'  => 'breadcrumb_setting',
  'default'  => '0',
  'priority' => 10,
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
// breadcrumb Shapes
$fields[] = [
  'type'     => 'switch',
  'settings' => 'breadcrumb_shapes_switch',
  'label'    => esc_html__('Breadcrumb Shapes on/off?', 'webency'),
  'section'  => 'breadcrumb_setting',
  'default'  => '0',
  'priority' => 10,
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'show_breadcrumb',
      'operator' => '==',
      'value'    => '1',
    ],
  ],
];
