<?php

/**
 * Customizer Contact Infos
 *
 * style for theme Contact Infos
 */

$fields[] = array(
  'type'     => 'custom',
  'settings' => 'general_custom_01',
  'label'    => FALSE,
  'section'  => 'webency_contact_infos',
  'default'  => '<div class="customizer_label">' . esc_html__('Contact Infos', 'webency') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
);
// number
$fields[] = [
  'type'            => 'text',
  'settings'        => 'contact_phone_number',
  'label'           => esc_html__('Contact Number', 'webency'),
  'section'         => 'webency_contact_infos',
  'default'         => esc_html__('+(081)-2345-6789', 'webency'),
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
// email
$fields[] = [
  'type'            => 'text',
  'settings'        => 'contact_email',
  'label'           => esc_html__('Contact Email', 'webency'),
  'section'         => 'webency_contact_infos',
  'default'         => esc_html__('mail@webency.com', 'webency'),
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
// location
$fields[] = [
  'type'            => 'text',
  'settings'        => 'contact_location',
  'label'           => esc_html__('Location', 'webency'),
  'section'         => 'webency_contact_infos',
  'default'         => esc_html__('225 Marion Street, Columbia', 'webency'),
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];

$fields[] = array(
  'type'     => 'custom',
  'settings' => 'general_custom_02',
  'label'    => FALSE,
  'section'  => 'webency_contact_infos',
  'default'  => '<div class="customizer_label">' . esc_html__('Socials Info', 'webency') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
);
// facebook
$fields[] = [
  'type'            => 'text',
  'settings'        => 'header_fb_link',
  'label'           => esc_html__('Facebook', 'webency'),
  'section'         => 'webency_contact_infos',
  'default'         => esc_html__('https://facebook.com/', 'webency'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
// twitter
$fields[] = [
  'type'            => 'text',
  'settings'        => 'header_twitter_link',
  'label'           => esc_html__('Twitter', 'webency'),
  'section'         => 'webency_contact_infos',
  'default'         => esc_html__('https://twitter.com/', 'webency'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
// linkedin
$fields[] = [
  'type'            => 'text',
  'settings'        => 'header_linkedin_link',
  'label'           => esc_html__('Linkedin', 'webency'),
  'section'         => 'webency_contact_infos',
  'default'         => esc_html__('https://linkedin.com/', 'webency'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
// instagram
$fields[] = [
  'type'            => 'text',
  'settings'        => 'header_instagram_link',
  'label'           => esc_html__('Instagram', 'webency'),
  'section'         => 'webency_contact_infos',
  'default'         => esc_html__('https://instagram.com/', 'webency'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
// youtube
$fields[] = [
  'type'            => 'text',
  'settings'        => 'header_youtube_link',
  'label'           => esc_html__('Youtube', 'webency'),
  'section'         => 'webency_contact_infos',
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ]
  ],
];
