<?php

/**
 * Customizer Footer Settings
 *
 * style for theme footer
 */

$footers = Kirki_Helper::get_posts([
  'post_type'      => 'tj-footer-builder',
  'post_status'    => 'publish',
  'posts_per_page' => -1,
  'orderby'        => 'title',
  'order'          => 'ASC',
]);

// select footers
$fields[] = [
  'type'     => 'custom',
  'settings' => 'footer_custom_01',
  'label'    => FALSE,
  'section'  => 'footer_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Select Footers', 'webency') . '</div>',
];
$fields[] = [
  'type'     => 'select',
  'settings' => 'select_footers',
  'section'  => 'footer_settings',
  'default'  => 'default',
  'choices'  => [
    'default' => esc_html__('Default Footers', 'webency'),
    'elementor'  => esc_html__('Elementor Footers', 'webency'),
  ],
];

if (!empty($footers)) :
  $fields[] = [
    'type'            => 'custom',
    'settings'        => 'footer_custom_02',
    'label'           => FALSE,
    'section'         => 'footer_settings',
    'default'         => '<div class="customizer_label mt-25">' . esc_html__('Choose Elementor Style', 'webency') . '</div>',
    'active_callback' => [
      [
        'setting'  => 'select_footers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
  $fields[] = [
    'type'            => 'select',
    'settings'        => 'elementor_footer_style',
    'section'         => 'footer_settings',
    'choices'         => $footers,
    'default'         => 'footer-1',
    'active_callback' => [
      [
        'setting'  => 'select_footers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
else :
  $fields[] = [
    'type'            => 'custom',
    'settings'        => 'footer_custom_02',
    'label'           => FALSE,
    'section'         => 'footer_settings',
    'default'         => '<div class="alert alert-warning" role="alert">' . esc_html__('No Footers Found! — set elementor footer {Appearance -> TJ Footer Builder}', 'webency') . '</div>',
    'active_callback' => [
      [
        'setting'  => 'select_footers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
endif;

// Select Default Footer
$fields[] = [
  'type'            => 'custom',
  'settings'        => 'footer_custom_03',
  'label'           => FALSE,
  'section'         => 'footer_settings',
  'default'         => '<div class="customizer_label mt-25">' . esc_html__('Choose Default Style', 'webency') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
$fields[] = [
  'type'            => 'radio-image',
  'settings'        => 'default_footer_style',
  'label'           => FALSE,
  'section'         => 'footer_settings',
  'placeholder'     => esc_html__('Select an option...', 'webency'),
  'priority'        => 10,
  'multiple'        => 1,
  'choices'         => [
    'footer-style-1' => WEBENCY_INC_URL . '/assets/img/footer/footer-1.png',
    'footer-style-2' => WEBENCY_INC_URL . '/assets/img/footer/footer-2.png',
    'footer-style-3' => WEBENCY_INC_URL . '/assets/img/footer/footer-3.png',
    'footer-style-4' => WEBENCY_INC_URL . '/assets/img/footer/footer-4.png',
  ],
  'default'         => 'footer-style-1',
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

$fields[] = [
  'type'            => 'custom',
  'settings'        => 'footer_custom_04',
  'label'           => FALSE,
  'section'         => 'footer_settings',
  'default'         => '<div class="customizer_label mt-25">' . esc_html__('Footer Settings', 'webency') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// Footer Column
$fields[] = [
  'type'            => 'select',
  'settings'        => 'footer_widget_column',
  'label'           => esc_html__('Widget Column', 'webency'),
  'section'         => 'footer_settings',
  'default'         => '4',
  'placeholder'     => esc_html__('Select an option...', 'webency'),
  'priority'        => 10,
  'multiple'        => 1,
  'choices'         => [
    '4' => esc_html__('Column 4', 'webency'),
    '3' => esc_html__('Column 3', 'webency'),
    '2' => esc_html__('Column 2', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// footer style 2 switcher 
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'footer_style_2_switch',
  'label'           => esc_html__('Show footer style 2?', 'webency'),
  'section'         => 'footer_settings',
  'default'         => '1',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// footer style 3 switcher 
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'footer_style_3_switch',
  'label'           => esc_html__('Show footer style 3?', 'webency'),
  'section'         => 'footer_settings',
  'default'         => '1',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// footer style 4 switcher 
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'footer_style_4_switch',
  'label'           => esc_html__('Show footer style 4?', 'webency'),
  'section'         => 'footer_settings',
  'default'         => '1',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// footer bg image
$fields[] = [
  'type'            => 'image',
  'settings'        => 'footer_bg_img',
  'label'           => esc_html__('Background Image', 'webency'),
  'section'         => 'footer_settings',
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// footer bg color
$fields[] = [
  'type'            => 'color',
  'settings'        => 'footer_bg_color',
  'label'           => esc_html__('Background Color', 'webency'),
  'description'     => esc_html__('This color will be show footer background.', 'webency'),
  'section'         => 'footer_settings',
  'default'         => '#282828',
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// copyright text
$fields[] = [
  'type'            => 'textarea',
  'settings'        => 'webency_copyright',
  'label'           => esc_html__('Copyright Text', 'webency'),
  'section'         => 'footer_settings',
  'default'         => webency_kses('Copyright © 2024 <a href="#" target="_blank"> ThemeJunction. </a> All Rights
  Reserved.'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

// footer menu switcher
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'footer_menu_switcher',
  'label'           => esc_html__('Footer Bottom Menu', 'webency'),
  'section'         => 'footer_settings',
  'default'         => '0',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];


// footer top switcher
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'footer_top_switcher',
  'label'           => esc_html__('Footer Top Area', 'webency'),
  'section'         => 'footer_settings',
  'default'         => '0',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_footer_style',
      'operator' => 'in',
      'value'    => ['footer-style-3'],
    ],
  ],
];
// top subtitle
$fields[] = [
  'type'            => 'text',
  'settings'        => 'footer_top_subtitle',
  'label'           => esc_html__('Subtitle', 'webency'),
  'section'         => 'footer_settings',
  'default'         => esc_html__('Get in touch', 'webency'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_footer_style',
      'operator' => 'in',
      'value'    => ['footer-style-3'],
    ],
    [
      'setting'  => 'footer_top_switcher',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// top title
$fields[] = [
  'type'            => 'text',
  'settings'        => 'footer_top_title',
  'label'           => esc_html__('Title', 'webency'),
  'section'         => 'footer_settings',
  'default'         => webency_kses('Get your Free Trial and <span>Quotation</span>'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_footer_style',
      'operator' => 'in',
      'value'    => ['footer-style-3'],
    ],
    [
      'setting'  => 'footer_top_switcher',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// top desc
$fields[] = [
  'type'            => 'textarea',
  'settings'        => 'footer_top_desc',
  'label'           => esc_html__('Description', 'webency'),
  'section'         => 'footer_settings',
  'default'         => webency_kses('All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet.'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_footer_style',
      'operator' => 'in',
      'value'    => ['footer-style-3'],
    ],
    [
      'setting'  => 'footer_top_switcher',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// top contact label
$fields[] = [
  'type'            => 'text',
  'settings'        => 'footer_top_contact_label',
  'label'           => esc_html__('Contact Label', 'webency'),
  'section'         => 'footer_settings',
  'default'         => esc_html__('Help Line:', 'webency'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_footer_style',
      'operator' => 'in',
      'value'    => ['footer-style-3'],
    ],
    [
      'setting'  => 'footer_top_switcher',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// top contact No
$fields[] = [
  'type'            => 'text',
  'settings'        => 'footer_top_contact_no',
  'label'           => esc_html__('Contact No:', 'webency'),
  'section'         => 'footer_settings',
  'default'         => esc_attr('+ 00 123 456 789'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_footer_style',
      'operator' => 'in',
      'value'    => ['footer-style-3'],
    ],
    [
      'setting'  => 'footer_top_switcher',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
// top contact form
$fields[] = [
  'type'            => 'text',
  'settings'        => 'footer_top_contact_form',
  'label'           => esc_html__('Form Shortcode', 'webency'),
  'section'         => 'footer_settings',
  'default'         => '',
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'select_footers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_footer_style',
      'operator' => 'in',
      'value'    => ['footer-style-3'],
    ],
    [
      'setting'  => 'footer_top_switcher',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
