<?php

/**
 * Customizer General Settings
 *
 * style for theme general settings
 */

$fields[] = [
    'type'     => 'custom',
    'settings' => 'general_custom_01',
    'label'    => FALSE,
    'section'  => 'general_settings',
    'default'  => '<div class="customizer_label">' . esc_html__('Global Site Settings', 'webency') . '</div>',
];
// backToTop
$fields[] = [
    'type'     => 'switch',
    'settings' => 'webency_backtotop',
    'label'    => esc_html__('Show Back to Top', 'webency'),
    'section'  => 'general_settings',
    'default'  => '0',
    'priority' => 10,
    'choices'  => [
        'on'  => esc_html__('Enable', 'webency'),
        'off' => esc_html__('Disable', 'webency'),
    ],
];

// preloader
$fields[] = [
    'type'     => 'switch',
    'settings' => 'show_preloader',
    'label'    => esc_html__('Show Preloader', 'webency'),
    'section'  => 'general_settings',
    'default'  => '0',
    'choices'  => [
        'on'  => esc_html__('Enable', 'webency'),
        'off' => esc_html__('Disable', 'webency'),
    ],
];
// loader cancel text
$fields[] = array(
    'type'            => 'text',
    'settings'        => 'loader_loading_text',
    'label'           => esc_html__('Preloader Text', 'webency'),
    'section'         => 'general_settings',
    'default'         => esc_html__('Loading', 'webency'),
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);
// background color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_bg_color',
    'label'           => esc_html__('Loader BG Color', 'webency'),
    'section'         => 'general_settings',
    'default'         => '#0e0e0e',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '.preloader',
            'property' => 'background',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);

// loader cancel text
$fields[] = array(
    'type'            => 'text',
    'settings'        => 'loader_cancel_text',
    'label'           => esc_html__('Loader Cancel Btn Text', 'webency'),
    'section'         => 'general_settings',
    'default'         => esc_html__('Cancel Preloader', 'webency'),
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);
// cancel button text color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_cancel_text_color',
    'label'           => esc_html__('Cancel Btn Text Color', 'webency'),
    'section'         => 'general_settings',
    'default'         => '#ffffff',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '.preloader .tj-cancel-btn',
            'property' => 'color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);
// cancel button hover text color
$fields[] = array(
    'type'            => 'color',
    'settings'        => 'loader_cancel_hover_text_color',
    'label'           => esc_html__('Cancel Btn Hover Text Color', 'webency'),
    'section'         => 'general_settings',
    'default'         => '#ffffff',
    'choices'         => [
        'alpha' => true,
    ],
    'transport'       => 'auto',
    'output'          => [
        [
            'element'  => '.preloader .tj-cancel-btn:hover',
            'property' => 'color',
        ],
    ],
    'active_callback' => [
        [
            'setting'  => 'show_preloader',
            'operator' => '==',
            'value'    => true,
        ],
    ],
);
// google_map_api
$fields[] = array(
    'type'            => 'text',
    'settings'        => 'google_map_api',
    'label'           => esc_html__('Google Map API Key', 'webency'),
    'section'         => 'general_settings',
    'transport'       => 'auto',
);
