<?php

/**
 * Customizer Header Settings
 *
 * style for theme headers
 */

$headers = Kirki_Helper::get_posts([
  'post_type'      => 'tj-header-builder',
  'post_status'    => 'publish',
  'posts_per_page' => -1,
  'orderby'        => 'title',
  'order'          => 'ASC',
]);

// select headers
$fields[] = [
  'type'     => 'custom',
  'settings' => 'header_setting_custom_01',
  'label'    => FALSE,
  'section'  => 'header_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Select Headers', 'webency') . '</div>',
];
$fields[] = [
  'type'     => 'select',
  'settings' => 'select_headers',
  'section'  => 'header_settings',
  'default'  => 'default',
  'choices'  => [
    'default' => esc_html__('Default Headers', 'webency'),
    'elementor'  => esc_html__('Elementor Headers', 'webency'),
  ],
];
if (!empty($headers)) :
  $fields[] = [
    'type'            => 'custom',
    'settings'        => 'header_setting_custom_02',
    'label'           => FALSE,
    'section'         => 'header_settings',
    'default'         => '<div class="customizer_label mt-25">' . esc_html__('Choose Elementor Style', 'webency') . '</div>',
    'active_callback' => [
      [
        'setting'  => 'select_headers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
  $fields[] = [
    'type'            => 'select',
    'settings'        => 'elementor_header_style',
    'section'         => 'header_settings',
    'choices'         => $headers,
    'default'         => 'header-1',
    'active_callback' => [
      [
        'setting'  => 'select_headers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
else :
  $fields[] = [
    'type'            => 'custom',
    'settings'        => 'header_custom_02',
    'label'           => FALSE,
    'section'         => 'header_settings',
    'default'         => '<div class="alert alert-warning" role="alert">' . esc_html__('No Headers Found! — set elementor header {Appearance -> TJ Header Builder}', 'webency') . '</div>',
    'active_callback' => [
      [
        'setting'  => 'select_headers',
        'operator' => '==',
        'value'    => 'elementor',
      ],
    ],
  ];
endif;

$fields[] = [
  'type'            => 'custom',
  'settings'        => 'header_setting_custom_03',
  'label'           => FALSE,
  'section'         => 'header_settings',
  'default'         => '<div class="customizer_label mt-25">' . esc_html__('Choose Default Style', 'webency') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// Header Default
$fields[] = [
  'type'            => 'radio-image',
  'settings'        => 'default_header_style',
  'section'         => 'header_settings',
  'priority'        => 10,
  'multiple'        => 1,
  'choices'         => [
    'header-style-1' => WEBENCY_INC_URL . '/assets/img/header/header-1.png',
    'header-style-2' => WEBENCY_INC_URL . '/assets/img/header/header-2.png',
    'header-style-3' => WEBENCY_INC_URL . '/assets/img/header/header-3.png',
    'header-style-4' => WEBENCY_INC_URL . '/assets/img/header/header-4.png',
  ],
  'default'         => 'header-style-1',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];

$fields[] = [
  'type'     => 'custom',
  'settings' => 'header_setting_custom_04',
  'label'    => FALSE,
  'section'  => 'header_settings',
  'default'  => '<div class="customizer_label mt-25">' . esc_html__('Header Settings', 'webency') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// header sticky
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'header_sticky',
  'label'           => esc_html__('Is header sticky?', 'webency'),
  'section'         => 'header_settings',
  'default'         => '0',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// header absolute
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'header_absolute',
  'label'           => esc_html__('Is header absolute?', 'webency'),
  'section'         => 'header_settings',
  'default'         => '0',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// right button
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'header_right_button',
  'label'           => esc_html__('Show button?', 'webency'),
  'section'         => 'header_settings',
  'default'         => '0',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// right button text
$fields[] = [
  'type'            => 'text',
  'settings'        => 'header_right_button_text',
  'label'           => esc_html__('Button Text', 'webency'),
  'section'         => 'header_settings',
  'default'         => esc_html__('Contact Us', 'webency'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'header_right_button',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
// right button link
$fields[] = [
  'type'            => 'link',
  'settings'        => 'header_right_button_link',
  'label'           => esc_html__('Button Link', 'webency'),
  'section'         => 'header_settings',
  'default'         => esc_html__('#', 'webency'),
  'priority'        => 10,
  'active_callback' => [
    [
      'setting'  => 'header_right_button',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
  ],
];
