<?php

/**
 * Customizer Header TopBar
 *
 * style for theme header TopBar
 */

$fields[] = [
  'type'     => 'custom',
  'settings' => 'topbar_custom_01',
  'label'    => FALSE,
  'section'  => 'header_top_bar',
  'default'  => '<div class="customizer_label">' . esc_html__('Header Top Bar', 'webency') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
  ],
];
// Header Top Bar switcher
$fields[] = [
  'type'     => 'switch',
  'settings' => 'webency_topbar_switch',
  'label'    => esc_html__('Topbar Switcher', 'webency'),
  'section'  => 'header_top_bar',
  'default'  => '0',
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
  ],
];

// phone switcher
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'topbar_phone',
  'label'           => esc_html__('Show topbar Phone?', 'webency'),
  'section'         => 'header_top_bar',
  'default'         => '1',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
    [
      'setting'  => 'webency_topbar_switch',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];

// email switcher
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'topbar_email',
  'label'           => esc_html__('Show topbar email?', 'webency'),
  'section'         => 'header_top_bar',
  'default'         => '1',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
    [
      'setting'  => 'webency_topbar_switch',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];

// socials switcher
$fields[] = [
  'type'            => 'switch',
  'settings'        => 'topbar_socials',
  'label'           => esc_html__('Show topbar socials?', 'webency'),
  'section'         => 'header_top_bar',
  'default'         => '1',
  'priority'        => 10,
  'choices'         => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
    [
      'setting'  => 'webency_topbar_switch',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];


// on Mobile
$fields[] = [
  'type'     => 'custom',
  'settings' => 'topbar_custom_02',
  'label'    => FALSE,
  'section'  => 'header_top_bar',
  'default'  => '<div class="customizer_label">' . esc_html__('Header Top Bar on Mobile', 'webency') . '</div>',
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'webency_topbar_switch',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
  ],
];

// Header Top Bar on Mobile switcher
$fields[] = [
  'type'     => 'switch',
  'settings' => 'webency_topbar_mobile_switch',
  'label'    => esc_html__('Topbar Switcher', 'webency'),
  'section'  => 'header_top_bar',
  'default'  => 'on',
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'webency_topbar_switch',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
  ],
];

// mobile topbar contact no
$fields[] = [
  'type'     => 'switch',
  'settings' => 'topbar_mobile_phone_switcher',
  'label'    => esc_html__('Show topbar phone no?', 'webency'),
  'section'  => 'header_top_bar',
  'default'  => 'on',
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
    [
      'setting'  => 'webency_topbar_switch',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'topbar_phone',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'webency_topbar_mobile_switch',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];

// mobile topbar email
$fields[] = [
  'type'     => 'switch',
  'settings' => 'topbar_mobile_email_switcher',
  'label'    => esc_html__('Show topbar email?', 'webency'),
  'section'  => 'header_top_bar',
  'default'  => 'on',
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
    [
      'setting'  => 'webency_topbar_switch',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'topbar_email',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'webency_topbar_mobile_switch',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];

// Mobile social switcher
$fields[] = [
  'type'     => 'switch',
  'settings' => 'topbar_mobile_socials_switcher',
  'label'    => esc_html__('Show topbar socials?', 'webency'),
  'section'  => 'header_top_bar',
  'default'  => 'on',
  'choices'  => [
    'on'  => esc_html__('Enable', 'webency'),
    'off' => esc_html__('Disable', 'webency'),
  ],
  'active_callback' => [
    [
      'setting'  => 'select_headers',
      'operator' => '==',
      'value'    => 'default',
    ],
    [
      'setting'  => 'default_header_style',
      'operator' => 'in',
      'value'    => ['header-style-2'],
    ],
    [
      'setting'  => 'webency_topbar_switch',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'topbar_socials',
      'operator' => '==',
      'value'    => true,
    ],
    [
      'setting'  => 'webency_topbar_mobile_switch',
      'operator' => '==',
      'value'    => true,
    ],
  ],
];
