<?php

/**
 * Customizer Typography Settings
 *
 * style for theme typography
 */

$fields[] = array(
  'type'     => 'custom',
  'settings' => 'font_custom_01',
  'label'    => FALSE,
  'section'  => 'typo_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Body Font', 'webency') . '</div>',
);
$fields[] = array(
  'type'        => 'typography',
  'settings'    => 'body_fonts',
  'section'     => 'typo_settings',
  'description' => esc_html__('Body Font by default effect on each element under body excepts some special elements those are under Heading Font.', 'webency'),
  'default'     => [
    'font-family' => "Ubuntu",
    'variant'     => '400',
    'font-size'   => '16px',
    'line-height' => '1.6',
  ],
  'transport'   => 'auto',
  'output'      => [
    [
      'choice'   => 'font-family',
      'element'  => ':root',
      'property' => '--tj-ff-body',
    ],
    [
      'choice'   => 'font-weight',
      'element'  => 'body',
      'property' => 'font-weight',
    ],
    [
      'choice'   => 'font-size',
      'element'  => ':root',
      'property' => '--tj-fs-body',
    ],
    [
      'choice'   => 'line-height',
      'element'  => 'body',
      'property' => 'line-height',
    ],
  ],
);
$fields[] = array(
  'type'     => 'custom',
  'settings' => 'font_custom_02',
  'label'    => FALSE,
  'section'  => 'typo_settings',
  'default'  => '<div class="customizer_label">' . esc_html__('Heading Font', 'webency') . '</div>',
);
$fields[] = array(
  'type'        => 'typography',
  'settings'    => 'secondary_fonts',
  'section'     => 'typo_settings',
  'default'     => [
    'font-family' => "Ubuntu",
    'variant'     => '700',
  ],
  'description' => esc_html__('This typography settings only for heading, buttons and some special elements.', 'webency'),
  'transport'   => 'auto',
  'output'      => [
    [
      'choice'   => 'font-family',
      'element'  => ':root',
      'property' => '--tj-ff-heading',
    ],
    [
      'choice'   => 'font-weight',
      'element'  => 'h1,h2,h3,h4,h5,h6',
      'property' => 'font-weight',
    ],
  ],
);
