<?php

/**
 * Webency TGM_Config
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

class TGM_Config {

  public function __construct() {
    add_action('tgmpa_register', array($this, 'register_required_plugins'));
  }
  public function register_required_plugins() {
    $plugins = [
      // Bundled
      [
        'name'               => esc_html__('TJ Webency Core', 'webency'),
        'slug'               => 'tj-webency-core',
        'required'           => true,
        'source'             => esc_url('https://themejunction.net/plugins/tj-webency-core.zip'),
        'external_url'       =>  esc_url('https://themejunction.net/plugins/tj-webency-core.zip'),
      ],
      [
        'name'               => esc_html__('Advanced Custom Fields Pro', 'webency'),
        'slug'               => 'advanced-custom-fields-pro',
        'required'           => true,
        'source'             => esc_url('https://themejunction.net/plugins/advanced-custom-fields-pro.zip'),
        'external_url' => esc_url('https://themejunction.net/plugins/advanced-custom-fields-pro.zip'),
      ],

      // Repository
      [
        'name'     => esc_html__('Kirki', 'webency'),
        'slug'     => 'kirki',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Elementor', 'webency'),
        'slug'     => 'elementor',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Advanced Custom Fields: Font Awesome Field', 'webency'),
        'slug'     => 'advanced-custom-fields-font-awesome',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Breadcrumb NavXT', 'webency'),
        'slug'     => 'breadcrumb-navxt',
        'required' => true,
      ],
      [
        'name'     => esc_html__('Contact Form 7', 'webency'),
        'slug'     => 'contact-form-7',
        'required' => true,
      ],
      [
        'name'     => esc_html__('MC4WP: Mailchimp for WordPress', 'webency'),
        'slug'     => 'mailchimp-for-wp',
        'required' => true,
      ],
      [
        'name'     => esc_html__('One Click Demo Import', 'webency'),
        'slug'     => 'one-click-demo-import',
        'required' => false,
      ],
      [
        'name'     => esc_html__('Classic Editor', 'webency'),
        'slug'     => 'classic-editor',
        'required' => false,
      ],
      [
        'name'     => esc_html__('Classic Widgets', 'webency'),
        'slug'     => 'classic-widgets',
        'required' => false,
      ],
    ];

    $config = [
      'id'           => 'webency',            // Unique ID for hashing notices for multiple instances of TGMPA.
      'default_path' => '',              // Default absolute path to bundled plugins.
      'menu'         => 'install-required-plugins', // Menu slug.
      'has_notices'  => true,                    // Show admin notices or not.
      'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
      'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
      'is_automatic' => false,                    // Automatically activate plugins after installation or not.
      'message'      => '',                      // Message to output right before the plugins table.
    ];

    tgmpa($plugins, $config);
  }
}
new TGM_Config;
