<?php

/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */


/** ---------------------------------------------------------------
 * Get All Types Post
 *---------------------------------------------------------------*/
if (!function_exists('webency_get_all_types_post')) {
	function webency_get_all_types_post($post_type) {

		$posts_args = get_posts(array(
			'post_type'      => $post_type,
			'orderby'        => 'date',
			'order'          => 'DESC',
			'post_status'    => 'publish',
			'posts_per_page' => -1,
		));

		$posts = [];

		if (!empty($posts_args) && !is_wp_error($posts_args)) {
			foreach ($posts_args as $post) {
				$posts[$post->ID] = $post->post_title;
			}
		}

		return $posts;
	}
}

/**
 * ---------------------------------------------------------------------------------------
 * Get all tags
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_get_tag')) {
	function webency_get_tag() {
		$html = '';
		if (has_tag()) {
			$html .= '<div class="tj-tag tagcloud">';
			$html .= '<span class="tag__title">' . esc_html__('Tags : ', 'webency') . '</span>';
			$html .= get_the_tag_list('', ' ', '');
			$html .= '</div>';
		}
		return $html;
	}
}

/**
 * ---------------------------------------------------------------------------------------
 * Get all category
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_get_category')) {
	function webency_get_category() {

		$categories = get_the_category(get_the_ID());
		$x = 0;
		foreach ($categories as $category) {

			if ($x == 2) {
				break;
			}
			$x++;
			print '<a class="post__category" href="' . get_category_link($category->term_id) . '">' . $category->cat_name . '</a>';
		}
	}
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Image Alt Text
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_img_alt_text')) {
	function webency_img_alt_text($img_er_id = null) {
		$image_id = $img_er_id;
		$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', false);
		$image_title = get_the_title($image_id);

		if (!empty($image_id)) {
			if ($image_alt) {
				$alt_text = get_post_meta($image_id, '_wp_attachment_image_alt', false);
			} else {
				$alt_text = $image_title;
			}
		} else {
			$alt_text = esc_html__('Image Alt Text', 'webency');
		}

		return $alt_text;
	}
}

/**
 * ---------------------------------------------------------------------------------------
 * Services Sidebar Function
 * ---------------------------------------------------------------------------------------
 */
function webency_service_sidebar() {
	if (is_active_sidebar('services-sidebar')) {

		dynamic_sidebar('services-sidebar');
	}
}
add_action('webency_service_sidebar', 'webency_service_sidebar', 20);

/**
 * ---------------------------------------------------------------------------------------
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 * ---------------------------------------------------------------------------------------
 */
function webency_pingback_header() {
	if (is_singular() && pings_open()) {
		printf('<link rel="pingback" href="%s">', esc_url(get_bloginfo('pingback_url')));
	}
}
add_action('wp_head', 'webency_pingback_header');
