<?php

/**
 * Functions which enhance the theme by Custom Functions
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

/**
 * ---------------------------------------------------------------------------------------
 * Webency Before Content
 * ---------------------------------------------------------------------------------------
 */
// Preloader
add_action('webency_before_main_content', 'webency_preloader');
function webency_preloader() {
  $webencyPreloader = get_theme_mod('show_preloader', false);
  $loaderCancelText = get_theme_mod('loader_cancel_text', esc_html__('Cancel Preloader', 'webency'));
  $loaderText = get_theme_mod('loader_loading_text', esc_html__('Loading', 'webency'));

  if (!empty($webencyPreloader)) :
?>
    <!-- start: Preloader -->
    <div class="preloader" id="preloader">
      <div class="preloader-inner">
        <div class="lines">
          <span class="line line-1"></span>
          <span class="line line-2"></span>
          <span class="line line-3"></span>
          <span class="line line-4"></span>
          <span class="line line-5"></span>
          <span class="line line-6"></span>
          <span class="line line-7"></span>
          <span class="line line-8"></span>
          <span class="line line-9"></span>
        </div>
        <?php if (!empty($loaderText)) : ?>
          <div class="text"><?php echo esc_html($loaderText); ?></div>
        <?php endif; ?>
      </div>
      <?php if (!empty($loaderCancelText)) : ?>
        <button class="tj-cancel-btn"><?php echo esc_html($loaderCancelText); ?></button>
      <?php endif; ?>
    </div>
    <!-- end: Preloader -->
  <?php
  endif;
}

// Back to Top
add_action('webency_before_main_content', 'webency_back_to_top');
function webency_back_to_top() {

  $webencyBackToTop = get_theme_mod('webency_backtotop', false);

  if (!empty($webencyBackToTop)) :
  ?>
    <!-- start: Scroll Area -->
    <div class="webency-scroll-top">
      <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="
                        transition: stroke-dashoffset 10ms linear 0s;
                        stroke-dasharray: 307.919px, 307.919px;
                        stroke-dashoffset: 71.1186px;
                    "></path>
      </svg>
      <div class="webency-scroll-top-icon">
        <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="1em" height="1em" viewBox="0 0 24 24" data-icon="mdi:arrow-up" class="iconify iconify--mdi">
          <path fill="currentColor" d="M13 20h-2V8l-5.5 5.5l-1.42-1.42L12 4.16l7.92 7.92l-1.42 1.42L13 8v12Z">
          </path>
        </svg>
      </div>
    </div>
    <!-- end: Scroll Area -->
    <?php
  endif;
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Search Filter
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_search_filter_form')) {
  function webency_search_filter_form($form) {

    $form = sprintf(
      '<div class="tj-widget__search sidebar-search"><form action="%s" method="get">
       <input type="text" value="%s" required name="s" placeholder="%s">
       <button type="submit"> <i class="fa-regular fa-magnifying-glass"></i> </button>
    </form></div>',
      esc_url(home_url('/')),
      esc_attr(get_search_query()),
      esc_html__('Search...', 'webency')
    );

    return $form;
  }
  add_filter('get_search_form', 'webency_search_filter_form');
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Breadcrumb
 * ---------------------------------------------------------------------------------------
 */
add_action('webency_breadcrumb', 'webency_breadcrumb_func');
function webency_breadcrumb_func() {
  global $post;

  // id
  $_id = get_the_ID();

  $breadcrumb_class = '';
  $breadcrumb_show = 1;

  $show_breadcrumb = get_theme_mod('show_breadcrumb', true);

  $error_breadcrumb = get_theme_mod('error_show_breadcrumb', true);
  $webency_error_title = get_theme_mod('webency_error_title', __('404', 'webency'));

  // page breadcrumb title
  $page_breadcrumb_title = function_exists('get_field') ? get_field('page_breadcrumb_title', $_id) : '';

  if (!empty($show_breadcrumb)) :
    // title
    if (is_front_page() && is_home()) {
      $title = get_theme_mod('blog_breadcrumb_title', __('Blog', 'webency'));
      $breadcrumb_class = 'home_front_page';
    } elseif (is_front_page()) {
      $title = get_theme_mod('blog_breadcrumb_title', __('Blog', 'webency'));
      $breadcrumb_show = 0;
    } elseif (is_home()) {
      $title = get_theme_mod('blog_breadcrumb_title', __('Blog', 'webency'));
      $breadcrumb_class = 'home_blog_page';
    } elseif (is_single() && 'post' == get_post_type()) {
      if (!empty(get_theme_mod('blog_details_breadcrumb_title'))) {
        $title = get_theme_mod('blog_details_breadcrumb_title', __('Blog Details', 'webency'));
      } else {
        $title =  get_the_title();
      }
    } elseif (is_single() && 'product' == get_post_type()) {
      $title = get_theme_mod('breadcrumb_product_details', __('Shop', 'webency'));
    } elseif (is_search()) {
      $title = esc_html__('Search Results for : ', 'webency') . get_search_query();
    } elseif (is_404()) {
      $title = $webency_error_title ? $webency_error_title : esc_html__('404', 'webency');
      $breadcrumb_show = $error_breadcrumb ? 1 : 0;
    } elseif (function_exists('is_woocommerce') && is_woocommerce()) {
      $title = get_theme_mod('breadcrumb_shop', __('Shop', 'webency'));
    } elseif (is_archive() && 'services' == get_post_type()) {
      if (!empty(get_theme_mod('breadcrumb_services_title'))) {
        $title = get_theme_mod('breadcrumb_services_title', __('Services', 'webency'));
      } else {
        $title =  get_the_archive_title();
      }
    } elseif (is_archive() && 'teams' == get_post_type()) {
      if (!empty(get_theme_mod('breadcrumb_teams_title'))) {
        $title = get_theme_mod('breadcrumb_teams_title', __('Team Members', 'webency'));
      } else {
        $title =  get_the_archive_title();
      }
    } elseif (is_archive() && 'portfolios' == get_post_type()) {
      if (!empty(get_theme_mod('breadcrumb_portfolios_title'))) {
        $title = get_theme_mod('breadcrumb_portfolios_title', __('Portfolios', 'webency'));
      } else {
        $title =  get_the_archive_title();
      }
    } elseif (is_archive()) {
      $title = get_the_archive_title();
    } else {
      $title = !empty($page_breadcrumb_title) ? $page_breadcrumb_title : get_the_title();
    }


    if (is_single() && 'product' == get_post_type()) {
      $_id = $post->ID;
    } elseif (function_exists("is_shop") and is_shop()) {
      $_id = wc_get_page_id('shop');
    } elseif (is_home() && get_option('page_for_posts')) {
      $_id = get_option('page_for_posts');
    }


    // hide page breadcrumb
    if (is_singular() || is_page()) {
      $is_breadcrumb = function_exists('get_field') ? get_field('hide_page_breadcrumb', $_id) : false;
    } else {
      $is_breadcrumb = false;
    }


    if ((false == $is_breadcrumb) && $breadcrumb_show == 1) {
      // IMAGES
      $breadcrumb_page_bg_image = function_exists('get_field') ? get_field('breadcrumb_page_bg_image', $_id) : '';

      // customizer
      $customizer_bg_img = get_theme_mod('breadcrumb_bg_img');
      $bg_color = get_theme_mod('breadcrumb_bg_color', '#282828');

      $blog_breadcrumb_img = get_theme_mod('blog_breadcrumb_img');
      $blog_details_breadcrumb_img = get_theme_mod('blog_details_breadcrumb_img');

      $error_breadcrumb_img = get_theme_mod('webency_error_breadcrumb_img');
      $breadcrumb_service_img = get_theme_mod('breadcrumb_services_img');
      $breadcrumb_teams_img = get_theme_mod('breadcrumb_teams_img');
      $breadcrumb_portfolios_img = get_theme_mod('breadcrumb_portfolios_img');

      // image
      if (is_front_page() && is_home()) {
        $bg_img = $blog_breadcrumb_img ? $blog_breadcrumb_img : $customizer_bg_img;
      } elseif (is_front_page()) {
        $bg_img = $blog_breadcrumb_img ? $blog_breadcrumb_img : $customizer_bg_img;
      } elseif (is_home()) {
        $bg_img = $blog_breadcrumb_img ? $blog_breadcrumb_img : $customizer_bg_img;
      } elseif (is_single() && 'post' == get_post_type()) {
        $bg_img = $blog_details_breadcrumb_img ? $blog_details_breadcrumb_img : (has_post_thumbnail() ? get_the_post_thumbnail_url() : $customizer_bg_img);
      } elseif (is_404()) {
        $bg_img = $error_breadcrumb_img ? $error_breadcrumb_img : $customizer_bg_img;
      } elseif (is_archive() && 'services' == get_post_type()) {
        $bg_img = $breadcrumb_service_img ? $breadcrumb_service_img : $customizer_bg_img;
      } elseif (is_archive() && 'teams' == get_post_type()) {
        $bg_img = $breadcrumb_teams_img ? $breadcrumb_teams_img : $customizer_bg_img;
      } elseif (is_archive() && 'portfolios' == get_post_type()) {
        $bg_img = $breadcrumb_portfolios_img ? $breadcrumb_portfolios_img : $customizer_bg_img;
      } elseif (is_single()) {
        $bg_img = has_post_thumbnail() ? get_the_post_thumbnail_url() : $customizer_bg_img;
      } else {
        $bg_img = !empty($breadcrumb_page_bg_image['url']) ? $breadcrumb_page_bg_image['url'] : $customizer_bg_img;
      }

      // NAVIGATION
      $breadcrumb_navigation_switch = get_theme_mod('breadcrumb_navigation_switch', false);
      $show_page_breadcrumb_navigation = function_exists('get_field') ? get_field('show_page_breadcrumb_navigation', $_id) : true;

      if (false === $is_breadcrumb) {
        $is_navigation = (true === $show_page_breadcrumb_navigation) ? true : false;
      } else {
        $is_navigation = $breadcrumb_navigation_switch;
      }



      // Breadcrumb bg color
      if (!empty($bg_color)) {
        $bgColor = 'data-bg-color="' . $bg_color . '"';
      } else {
        $bgColor = "";
      }

      // Breadcrumb bg image
      if (!empty($bg_img)) {
        $bgImage = 'data-bg-image="' . $bg_img . '"';
      } else {
        $bgImage = "";
      }

      // shapes switcher
      $breadcrumb_shapes_switch = get_theme_mod('breadcrumb_shapes_switch', false);
    ?>


      <section class="breadcrumb-wrapper <?php echo esc_attr($breadcrumb_class); ?>" <?php echo esc_attr($bgColor); ?> <?php echo esc_attr($bgImage); ?>>
        <div class="container">
          <div class="row">
            <div class="col-lg-12">
              <div class="breadcrumb-content-area">
                <div class="breadcrumb-heading">
                  <h1 class="breadcrumb-title wow fadeInUp" data-wow-delay=".3s"><?php echo webency_kses($title); ?></h1>
                </div>

                <?php if (function_exists('bcn_display') && !empty($is_navigation)) : ?>
                  <div class="breadcrumb-link wow fadeInUp" data-wow-delay=".5s">
                    <?php bcn_display(); ?>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
        <?php if (!empty($breadcrumb_shapes_switch)) : ?>
          <div class="tj-breadcrumb-shape">
            <div class="breadcrumb-shape-1 pulse">
              <img src="<?php echo esc_url(WEBENCY_ASSETS_IMAGES_URL . "/shape/shape-7.svg"); ?>" alt="<?php echo esc_attr('shape'); ?>" />
            </div>
            <div class="breadcrumb-shape-2 shake-y">
              <img src="<?php echo esc_url(WEBENCY_ASSETS_IMAGES_URL . "/shape/shape-4.svg"); ?>" alt="<?php echo esc_attr('shape'); ?>" />
            </div>
            <div class="breadcrumb-shape-3 pulse">
              <img src="<?php echo esc_url(WEBENCY_ASSETS_IMAGES_URL . "/shape/shape-6.svg"); ?>" alt="<?php echo esc_attr('shape'); ?>" />
            </div>
            <div class="breadcrumb-shape-4 shake-y">
              <img src="<?php echo esc_url(WEBENCY_ASSETS_IMAGES_URL . "/shape/shape-4.svg"); ?>" alt="<?php echo esc_attr('shape'); ?>" />
            </div>
            <div class="breadcrumb-shape-5 pulse">
              <img src="<?php echo esc_url(WEBENCY_ASSETS_IMAGES_URL . "/shape/shape-6.svg"); ?>" alt="<?php echo esc_attr('shape'); ?>" />
            </div>
            <div class="breadcrumb-shape-6 pulse">
              <img src="<?php echo esc_url(WEBENCY_ASSETS_IMAGES_URL . "/shape/shape-51.svg"); ?>" alt="<?php echo esc_attr('shape'); ?>" />
            </div>
            <div class="breadcrumb-shape-7 shake-y">
              <img src="<?php echo esc_url(WEBENCY_ASSETS_IMAGES_URL . "/shape/shape-5.svg"); ?>" alt="<?php echo esc_attr('shape'); ?>" />
            </div>
            <div class="breadcrumb-shape-8 pulse">
              <img src="<?php echo esc_url(WEBENCY_ASSETS_IMAGES_URL . "/shape/shape-6.svg"); ?>" alt="<?php echo esc_attr('shape'); ?>" />
            </div>
          </div>
        <?php endif; ?>
      </section>
    <?php

    }
  endif;
}
add_filter('bcn_breadcrumb_title', 'webency_breadcrumb_current_title_trim', 3, 10);
function webency_breadcrumb_current_title_trim($title, $type, $id) {
  if (in_array('home', $type)) {
    $title = __('Home', 'webency');
  }
  if (in_array('post', $type)) {
    $title = wp_trim_words($title, 4, '...');
  }
  return $title;
}


/**
 * ---------------------------------------------------------------------------------------
 * Webency Header Style
 * ---------------------------------------------------------------------------------------
 */
add_action('webency_header_style', 'webency_check_header', 10);
function webency_check_header() {

  $webency_select_headers = get_theme_mod('select_headers', 'default');
  $elementor_header_style    = get_theme_mod('elementor_header_style', 0);
  $default_header_style   = get_theme_mod('default_header_style', 'header-style-1');

  // header style from page settings
  $enable_header_settings = function_exists('get_field') ? get_field('enable_header_settings') : false;
  $select_page_headers = function_exists('get_field') ? get_field('select_page_headers') : 'default-headers';

  $page_default_header_style = function_exists('get_field') ? get_field('page_default_header_style') : NULL;
  $page_elementor_header_style = function_exists('get_field') ? get_field('page_elementor_header_style') : NULL;


  // from page headers
  if (!empty($enable_header_settings)) {
    if ('default-headers' == $select_page_headers) {
      // page header style
      if ($page_default_header_style == 'header-style-1') {
        get_template_part('template-parts/header/header-1');
      } elseif ($page_default_header_style == 'header-style-2') {
        get_template_part('template-parts/header/header-2');
      } elseif ($page_default_header_style == 'header-style-3') {
        get_template_part('template-parts/header/header-3');
      } elseif ($page_default_header_style == 'header-style-4') {
        get_template_part('template-parts/header/header-4');
      }
    } else {
      if (class_exists('\\Elementor\\Plugin')) {
        if ($page_elementor_header_style) {
          TJ_HF_Builder::render_template($page_elementor_header_style->ID);
        } else {
          printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('No Headers Found! — set custom header {Appearance -> TJ Header Builder}', 'webency'));
        }
      } else {
        printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('Webency requires Elementor to be installed and activated.', 'webency'));
      }
    }
  } else {
    // from cutomizer headers
    if ('default' == $webency_select_headers) {
      /** default header style **/
      if ($default_header_style == 'header-style-4') {
        get_template_part('template-parts/header/header-4');
      } elseif ($default_header_style == 'header-style-3') {
        get_template_part('template-parts/header/header-3');
      } elseif ($default_header_style == 'header-style-2') {
        get_template_part('template-parts/header/header-2');
      } else {
        get_template_part('template-parts/header/header-1');
      }
    } else {
      if (class_exists('\\Elementor\\Plugin')) {
        if ($elementor_header_style > 0) {
          TJ_HF_Builder::render_template($elementor_header_style);
        } else {
          printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('No Headers Found! — set custom header {Appearance -> TJ Header Builder}', 'webency'));
        }
      } else {
        printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('Webency requires Elementor to be installed and activated.', 'webency'));
      }
    }
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Footer Style
 * ---------------------------------------------------------------------------------------
 */
add_action('webency_footer_style', 'webency_check_footer', 10);
function webency_check_footer() {

  $webency_select_footers = get_theme_mod('select_footers', 'default');
  $elementor_footer_style    = get_theme_mod('elementor_footer_style', 0);
  $default_footer_style   = get_theme_mod('default_footer_style', 'footer-style-1');

  // footer style from page settings
  $enable_footer_settings = function_exists('get_field') ? get_field('enable_footer_settings') : false;
  $select_page_footers = function_exists('get_field') ? get_field('select_page_footers') : 'default-footers';

  $page_default_footer_style = function_exists('get_field') ? get_field('page_default_footer_style') : NULL;
  $page_elementor_footer_style = function_exists('get_field') ? get_field('page_elementor_footer_style') : NULL;


  // from Page Footers
  if (!empty($enable_footer_settings)) {
    if ('default-footers' == $select_page_footers) {
      // page footer style
      if ($page_default_footer_style == 'footer-style-1') {
        get_template_part('template-parts/footer/footer-1');
      } elseif ($page_default_footer_style == 'footer-style-2') {
        get_template_part('template-parts/footer/footer-2');
      } elseif ($page_default_footer_style == 'footer-style-3') {
        get_template_part('template-parts/footer/footer-3');
      } elseif ($page_default_footer_style == 'footer-style-4') {
        get_template_part('template-parts/footer/footer-4');
      }
    } else {

      if (class_exists('\\Elementor\\Plugin')) {
        if ($page_elementor_footer_style) {
          TJ_HF_Builder::render_template($page_elementor_footer_style->ID);
        } else {
          printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('No Footers Found! — set custom header {Appearance -> TJ Footer Builder}', 'webency'));
        }
      } else {
        printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('Webency requires Elementor to be installed and activated.', 'webency'));
      }
    }
  } else {
    // from cutomizer Footers
    if ('default' == $webency_select_footers) {
      /** default footer style **/
      if ($default_footer_style == 'footer-style-4') {
        get_template_part('template-parts/footer/footer-4');
      } elseif ($default_footer_style == 'footer-style-3') {
        get_template_part('template-parts/footer/footer-3');
      } elseif ($default_footer_style == 'footer-style-2') {
        get_template_part('template-parts/footer/footer-2');
      } else {
        get_template_part('template-parts/footer/footer-1');
      }
    } else {

      if (class_exists('\\Elementor\\Plugin')) {
        if ($elementor_footer_style > 0) {
          TJ_HF_Builder::render_template($elementor_footer_style);
        } else {
          printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('No Footers Found! — set custom header {Appearance -> TJ Footer Builder}', 'webency'));
        }
      } else {
        printf('<div class="alert alert-warning" role="alert">%s</div>', esc_html__('Webency requires Elementor to be installed and activated.', 'webency'));
      }
    }
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Header Logo
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_header_logo')) {
  function webency_header_logo() { ?>
    <?php
    $enable_header_settings = function_exists('get_field') ? get_field('enable_header_settings') : false;
    $webency_page_sec_logo_on = function_exists('get_field') ? get_field('is_enable_sec_logo') : false;

    $webency_logo       = get_template_directory_uri() . '/assets/images/logo/primary-logo.png';
    $webency_logo_black = get_template_directory_uri() . '/assets/images/logo/secondary-logo.png';

    if (!empty($enable_header_settings)) {
      if (!empty($webency_page_sec_logo_on)) {
        $webency_site_logo = get_theme_mod('secondary_logo', $webency_logo_black);
      } else {
        $webency_site_logo      = get_theme_mod('primary_logo', $webency_logo);
      }
    } else {
      $webency_site_logo      = get_theme_mod('primary_logo', $webency_logo);
    }
    ?>

    <a class="primary-logo" href="<?php echo esc_url(home_url('/')); ?>">
      <img src="<?php echo esc_url($webency_site_logo); ?>" alt="<?php echo esc_attr__('logo', 'webency'); ?>" />
    </a>
  <?php
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Mobile Logo
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_mobile_logo')) {
  function webency_mobile_logo() { ?>
    <?php
    $mobile_logo       = get_template_directory_uri() . '/assets/images/logo/mobile-logo.png';

    $webency_mobile_logo      = get_theme_mod('mobile_logo', $mobile_logo);
    ?>

    <a class="mobile-logo" href="<?php echo esc_url(home_url('/')); ?>">
      <img src="<?php echo esc_url($webency_mobile_logo); ?>" alt="<?php echo esc_attr__('logo', 'webency'); ?>" />
    </a>
  <?php
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Header Menu
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_header_menu')) {
  function webency_header_menu() {

    if (has_nav_menu('main-menu')) {
      wp_nav_menu([
        'theme_location' => 'main-menu',
        'menu_class'     => '',
        'menu_id'        => '',
        'container'      => '',
        'fallback_cb'    => 'Webency_Navwalker_Class::fallback',
        'walker'         => new Webency_Navwalker_Class,
      ]);
    } else {
      wp_nav_menu([
        'menu_class'     => '',
        'container'      => '',
      ]);
    }
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Header Footer Menu
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_footer_menu')) {
  function webency_footer_menu() {
    if (has_nav_menu('footer-menu')) {
      wp_nav_menu([
        'theme_location' => 'footer-menu',
        'menu_class'     => '',
        'container'      => '',
        'fallback_cb'    => 'Webency_Navwalker_Class::fallback',
        'walker'         => new Webency_Navwalker_Class,
      ]);
    } else {
      wp_nav_menu([
        'menu_class'     => '',
        'container'      => '',
      ]);
    }
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Copyright Text
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_copyright_text')) {
  function webency_copyright_text() {
    $webency_copyright = get_theme_mod('webency_copyright', webency_kses('Copyright © 2024 <a href="#" target="_blank"> ThemeJunction. </a> All Rights
    Reserved.'));
    echo webency_kses($webency_copyright);
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Header Socials
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_header_socials')) {
  function webency_header_socials() {
    $webency_header_fb_link        = get_theme_mod('header_fb_link', __('https://facebook.com/', 'webency'));
    $webency_header_twitter_link   = get_theme_mod('header_twitter_link', __('https://twitter.com/', 'webency'));
    $webency_header_linkedin_link  = get_theme_mod('header_linkedin_link', __('https://linkedin.com/', 'webency'));
    $webency_header_instagram_link = get_theme_mod('header_instagram_link', __('https://instagram.com/', 'webency'));
    $webency_header_youtube_link   = get_theme_mod('header_youtube_link', __('', 'webency'));
  ?>
    <ul class="dot-style">
      <?php if (!empty($webency_header_fb_link)) : ?>
        <li><a href="<?php echo esc_url($webency_header_fb_link); ?>"><i class="fa-brands fa-facebook-f"></i></a></li>
      <?php endif; ?>

      <?php if (!empty($webency_header_twitter_link)) : ?>
        <li><a href="<?php echo esc_url($webency_header_twitter_link); ?>"><i class="fa-brands fa-x-twitter"></i></a></li>
      <?php endif; ?>

      <?php if (!empty($webency_header_instagram_link)) : ?>
        <li><a href="<?php echo esc_url($webency_header_instagram_link); ?>"><i class="fa-brands fa-instagram"></i></a></li>
      <?php endif; ?>

      <?php if (!empty($webency_header_linkedin_link)) : ?>
        <li><a href="<?php echo esc_url($webency_header_linkedin_link); ?>"><i class="fa-brands fa-linkedin-in"></i></a></li>
      <?php endif; ?>

      <?php if (!empty($webency_header_youtube_link)) : ?>
        <li><a href="<?php echo esc_url($webency_header_youtube_link); ?>"><i class="fa-brands fa-youtube"></i></a></li>
      <?php endif; ?>
    </ul>
  <?php
  }
}


/**
 * ---------------------------------------------------------------------------------------
 * Webency Pagination
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_pagination')) {

  function _webency_pagi_callback($pagination) {
    return $pagination;
  }

  //page navigation
  function webency_pagination($prev, $next, $pages, $args) {
    global $wp_query, $wp_rewrite;
    $menu                                         = '';
    $wp_query->query_vars['paged'] > 1 ? $current = $wp_query->query_vars['paged'] : $current = 1;

    if ($pages == '') {
      global $wp_query;
      $pages = $wp_query->max_num_pages;

      if (!$pages) {
        $pages = 1;
      }
    }

    $pagination = [
      'base'      => add_query_arg('paged', '%#%'),
      'format'    => '',
      'total'     => $pages,
      'current'   => $current,
      'prev_text' => $prev,
      'next_text' => $next,
      'type'      => 'array',
    ];

    //rewrite permalinks
    if ($wp_rewrite->using_permalinks()) {
      $pagination['base'] = user_trailingslashit(trailingslashit(remove_query_arg('s', get_pagenum_link(1))) . 'page/%#%/', 'paged');
    }

    if (!empty($wp_query->query_vars['s'])) {
      $pagination['add_args'] = ['s' => get_query_var('s')];
    }

    $pagi = '';
    if (paginate_links($pagination) != '') {
      $paginations = paginate_links($pagination);
      $pagi .= '<ul>';
      foreach ($paginations as $key => $pg) {
        $pagi .= '<li>' . $pg . '</li>';
      }
      $pagi .= '</ul>';
    }

    echo _webency_pagi_callback($pagi);
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * Webency Comment
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_comment')) {
  function webency_comment($comment, $args, $depth) {
    $GLOBAL['comment'] = $comment;
    extract($args, EXTR_SKIP);
    $args['reply_text'] = 'Reply';
    $replayClass        = 'comment-depth-' . esc_attr($depth);
  ?>
    <li class="tj__comment" id="comment-<?php comment_ID(); ?>">
      <div class="tj-comment__wrap">
        <?php if (get_avatar($comment)) : ?>
          <div class="comment__avatar">
            <?php echo get_avatar($comment, 80, null, null, ['class' => []]); ?>
          </div>
        <?php endif; ?>
        <div class="comment__text">
          <div class="avatar__name">
            <h5><?php echo get_comment_author_link(); ?></h5>
            <span><?php comment_time(get_option('date_format')); ?></span>
          </div>
          <?php comment_text(); ?>

          <div class="comment__reply">
            <?php comment_reply_link(array_merge($args, ['depth' => $depth, 'max_depth' => $args['max_depth']])); ?>
          </div>

        </div>
      </div>
  <?php
  }
}

/**
 * ---------------------------------------------------------------------------------------
 * WP kses allowed tags
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_kses')) {
  function webency_kses($raw) {

    $allowed_tags = array(
      'a'                             => array(
        'class'  => array(),
        'href'   => array(),
        'rel'    => array(),
        'title'  => array(),
        'target' => array(),
      ),
      'abbr'                          => array(
        'title' => array(),
      ),
      'b'                             => array(),
      'blockquote'                    => array(
        'cite' => array(),
      ),
      'cite'                          => array(
        'title' => array(),
      ),
      'code'                          => array(),
      'del'                           => array(
        'datetime' => array(),
        'title'    => array(),
      ),
      'dd'                            => array(),
      'div'                           => array(
        'class' => array(),
        'title' => array(),
        'style' => array(),
      ),
      'dl'                            => array(),
      'dt'                            => array(),
      'em'                            => array(),
      'h1'                            => array(),
      'h2'                            => array(),
      'h3'                            => array(),
      'h4'                            => array(),
      'h5'                            => array(),
      'h6'                            => array(),
      'i'                             => array(
        'class' => array(),
      ),
      'img'                           => array(
        'alt'    => array(),
        'class'  => array(),
        'height' => array(),
        'src'    => array(),
        'width'  => array(),
      ),
      'li'                            => array(
        'class' => array(),
      ),
      'ol'                            => array(
        'class' => array(),
      ),
      'p'                             => array(
        'class' => array(),
      ),
      'q'                             => array(
        'cite'  => array(),
        'title' => array(),
      ),
      'span'                          => array(
        'class' => array(),
        'title' => array(),
        'style' => array(),
      ),
      'iframe'                        => array(
        'width'       => array(),
        'height'      => array(),
        'scrolling'   => array(),
        'frameborder' => array(),
        'allow'       => array(),
        'src'         => array(),
      ),
      'strike'                        => array(),
      'br'                            => array(),
      'strong'                        => array(),
      'data-wow-duration'             => array(),
      'data-wow-delay'                => array(),
      'data-wallpaper-options'        => array(),
      'data-stellar-background-ratio' => array(),
      'ul'                            => array(
        'class' => array(),
      ),
      'svg'                           => array(
        'class'           => true,
        'aria-hidden'     => true,
        'aria-labelledby' => true,
        'role'            => true,
        'xmlns'           => true,
        'width'           => true,
        'height'          => true,
        'viewbox'         => true, // <= Must be lower case!
      ),
      'g'                             => array('fill' => true),
      'title'                         => array('title' => true),
      'path'                          => array('d' => true, 'fill' => true),
    );

    if (function_exists('wp_kses')) { // WP is here
      $allowed = wp_kses($raw, $allowed_tags);
    } else {
      $allowed = $raw;
    }

    return $allowed;
  }
}
