<?php

/**
 * Webency Theme Hooks Class
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

if (!function_exists('webency_setup')) :
  function webency_setup() {

    /* add title tag support */
    add_theme_support('title-tag');

    /* load theme languages */
    load_theme_textdomain('webency', WEBENCY_THEME_DIR . '/languages');

    /* Add default posts and comments RSS feed links to head */
    add_theme_support('automatic-feed-links');

    /* Add posts thumbnails */
    add_theme_support('post-thumbnails');

    /* Add Image Size */
    add_image_size('portfolio_thumb', 420, 325, true);
    add_image_size('portfolio_thumb_2', 425, 530, true);
    add_image_size('portfolio_thumb_3', 380, 500, true); // home 5
    add_image_size('team_thumb', 310, 420, true); // home 6
    add_image_size('team_thumb_1', 380, 500, true); // home 5
    add_image_size('service_thumb', 380, 500, true); // home 5
    add_image_size('service_thumb_1', 310, 420, true); // home 7
    add_image_size('blog_thumb_1', 425, 310, true);
    add_image_size('blog_thumb_2', 385, 290, true);

    /*
 * Switch default core markup for search form, comment form, and comments
 * to output valid HTML5.
 */
    add_theme_support(
      'html5',
      [
        'search-form',
        'comment-form',
        'comment-list',
        'gallery',
        'caption',
        'script',
        'style',
        'navigation-widgets'
      ]
    );

    /* Set up the WordPress core custom background feature. */
    add_theme_support(
      'custom-background',
      apply_filters(
        'webency_custom_background_args',
        [
          'default-color' => 'ffffff',
          'default-image' => '',
        ]
      )
    );

    /* Add theme support for selective refresh for widgets. */
    add_theme_support('customize-selective-refresh-widgets');

    /* Enable support for Post Formats. */
    add_theme_support('post-formats', ['image', 'audio', 'video', 'gallery', 'quote']);

    /* Add support for custom header */
    add_theme_support("custom-header");

    /* Add support for core custom logo. */
    add_theme_support('custom-logo', [
      'height'      => 195,
      'width'       => 60,
      'flex-width'  => true,
      'flex-height' => true,
    ]);

    /* Add support for Block Styles. */
    add_theme_support('wp-block-styles');

    /* Add support for full and wide align images. */
    add_theme_support('align-wide');

    /* Add support for editor styles. */
    add_theme_support('editor-styles');

    /* Add support for responsive embedded content. */
    add_theme_support('responsive-embeds');

    /* Support for elementor header and footer */
    if (class_exists('Header_Footer_Elementor')) {
      add_theme_support('header-footer-elementor');
    }

    /* Register nav menus. */
    register_nav_menus(
      [
        'main-menu'   => esc_html__('Main Menu', 'webency'),
        'footer-menu' => esc_html__('Footer Menu', 'webency'),
      ]
    );
  }

endif;
add_action('after_setup_theme', 'webency_setup');


/**
 *  ---------------------------------------------------------------------------------------
 *  Set the content width in pixels, based on the theme's design and stylesheet.
 *  ---------------------------------------------------------------------------------------
 */
function webency_content_width() {
  // This variable is intended to be overruled from themes.
  // Open WPCS issue: {@link https://github.com/WordPress-Coding-Standards/WordPress-Coding-Standards/issues/1043}.
  // phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedVariableFound
  $GLOBALS['content_width'] = apply_filters('webency_content_width', 640);
}
add_action('after_setup_theme', 'webency_content_width', 0);


/**
 * ---------------------------------------------------------------------------------------
 * Admin Custom Scripts
 * ---------------------------------------------------------------------------------------
 */
function webency_admin_custom_scripts() {
  wp_enqueue_media();
  wp_enqueue_style('webency-customizer-style', WEBENCY_INC_URL . '/assets/css/customizer-style.css', []);
  wp_enqueue_script('webency-admin-custom', WEBENCY_INC_URL . '/assets/js/admin-custom.js', ['jquery'], WEBENCY_THEME_VERSION, true);
}
add_action('admin_enqueue_scripts', 'webency_admin_custom_scripts');



/**
 *    ---------------------------------------------------------------------------------------
 *    Register widget area.
 *
 *  @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 *    ---------------------------------------------------------------------------------------
 */
function webency_widgets_init() {
  require_once WEBENCY_COMMON_DIR . '/template-widgets.php';
}
add_action('widgets_init', 'webency_widgets_init');


/**
 * ---------------------------------------------------------------------------------------
 *  Enqueue scripts and styles.
 * ---------------------------------------------------------------------------------------
 */
if (!function_exists('webency_scripts')) :
  require_once WEBENCY_COMMON_DIR . '/template-scripts.php';
endif;


/**
 * ---------------------------------------------------------------------------------------
 * ReArrange Comment Form
 * ---------------------------------------------------------------------------------------
 */
function webency_rearrange_comment_form($fields) {
  $comment = $fields['comment'];
  $author  = $fields['author'];
  $email   = $fields['email'];
  $url     = $fields['url'];
  $cookies = $fields['cookies'];

  unset($fields['comment']);
  unset($fields['author']);
  unset($fields['email']);
  unset($fields['url']);
  unset($fields['cookies']);

  $fields['author']  = $author;
  $fields['email']   = $email;
  $fields['url']     = $url;
  $fields['comment'] = $comment;
  $fields['cookies'] = $cookies;

  return $fields;
}
add_filter('comment_form_fields', 'webency_rearrange_comment_form');


/**
 * ---------------------------------------------------------------------------------------
 * Body Class
 * ---------------------------------------------------------------------------------------
 */
function webency_body_classes($classes) {
  $enable_header_settings = function_exists('get_field') ? get_field('enable_header_settings') : false;
  $is_page_header_absolute = function_exists('get_field') ? get_field('is_page_header_absolute') : false;
  $is_page_header_sticky = function_exists('get_field') ? get_field('is_page_header_sticky') : false;

  $header_absolute = get_theme_mod('header_absolute', false);
  $header_sticky = get_theme_mod('header_sticky', false);

  if (!empty($enable_header_settings)) {
    $isHeaderAbsolute = !empty($is_page_header_absolute) ? "absolute_header" : "";
    $isHeaderSticky = !empty($is_page_header_sticky) ? "sticky_header" : "";
  } else {
    $isHeaderAbsolute = !empty($header_absolute) ? "absolute_header" : "";
    $isHeaderSticky = !empty($header_sticky) ? "sticky_header" : "";
  }

  $classes[]    = $isHeaderAbsolute;
  $classes[]    = $isHeaderSticky;



  // add active header class
  $header_style = get_theme_mod('header_style', 1);
  $classes[]    = 'active_header_' . $header_style;

  // Adds a class of hfeed to non-singular pages.
  if (!is_singular()) {
    $classes[] = 'webency-page';
  }

  // Adds a class of no-sidebar when there is no sidebar present.
  if (!is_active_sidebar('blog-sidebar')) {
    $classes[] = 'no-sidebar';
  }

  // Add page slug as a body class
  global $post;
  if (isset($post)) {
    $classes[] = $post->post_name;
  }

  return $classes;
}
add_filter('body_class', 'webency_body_classes');
