<?php

/**
 * Template Name: Page Sidebar
 * 
 * The template for displaying Page with Sidebar
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

get_header();

$blog_column = is_active_sidebar('blog-sidebar') ? 8 : 12;
?>
<div class="tj-page__area full-width section-padding">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-<?php print esc_attr($blog_column); ?>">
        <div class="tj-page__container">
          <?php
          if (have_posts()) :
            while (have_posts()) : the_post();
              get_template_part('template-parts/content', 'page');
            endwhile;
          else :
            get_template_part('template-parts/content', 'none');
          endif;
          ?>
        </div>
      </div>

      <?php if (is_active_sidebar('blog-sidebar')) : ?>
        <!-- sidebar -->
        <div class="col-lg-4">
          <aside class="tj-main__sidebar">
            <?php get_sidebar(); ?>
          </aside>
        </div>
        <!--!sidebar -->
      <?php endif; ?>
    </div>
  </div>
</div>

<?php
get_footer();
