<?php

/**
 * The template for displaying search results pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#search-result
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

get_header();

$blog_column = is_active_sidebar('blog-sidebar') ? 8 : 12;
?>

<div class="full-width tj-posts__area tj-blog-page">
	<div class="container">
		<div class="row">
			<div class="col-lg-<?php print esc_attr($blog_column); ?> ">
				<!-- post container -->
				<div class="tj-post__container tj-post-wrapper">
					<?php
					if (have_posts()) : ?>

						<?php
						/* Start the Loop */
						while (have_posts()) : the_post(); ?>
							<?php
							/*
							* Include the Post-Type-specific template for the content.
							* If you want to override this in a child theme, then include a file
							* called content-___.php (where ___ is the Post Type name) and that will be used instead.
							*/
							get_template_part('template-parts/content', get_post_format()); ?>
						<?php
						endwhile;

						// pagination
						global $wp_query;
						$pages = $wp_query->max_num_pages;
						if ($pages > 1) {
						?>
							<div class="tj__pagination">
								<?php webency_pagination('<i class="far fa-arrow-left"></i>', '<i class="far fa-arrow-right"></i>', '', ['class' => '']); ?>
							</div>
					<?php
						};

					else :
						get_template_part('template-parts/content', 'none');
					endif;
					?>
				</div>
				<!-- !post container -->
			</div>

			<?php if (is_active_sidebar('blog-sidebar')) : ?>
				<!-- sidebar -->
				<div class="col-lg-4">
					<aside class="tj-main__sidebar tj-main-sidebar">
						<?php get_sidebar(); ?>
					</aside>
				</div>
				<!--!sidebar -->
			<?php endif; ?>
		</div>
	</div>
</div>

<?php
get_footer();
