<?php

/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

get_header();


$blog_column = is_active_sidebar('blog-sidebar') ? 8 : 12;
$webency_blog_social = get_theme_mod('webency_blog_social', false);
?>

<div class="tj-post-details__area full-width tj-blog-details">
	<div class="container">
		<div class="row">
			<div class="col-lg-<?php print esc_attr($blog_column); ?>">
				<!-- post details container -->
				<div class="tj-post-details__container tj-post-wrapper">
					<?php
					while (have_posts()) :
						the_post();

						get_template_part('template-parts/content', get_post_format());
					?>

						<?php if (has_tag() || !empty($webency_blog_social)) : ?>
							<!-- post tag & share -->
							<div class="single-blog-tag-share tj-tags-post <?php echo (!empty($webency_blog_social) ? "" : "no-social-share"); ?>">
								<!-- post tags -->
								<?php if (has_tag()) {
									echo webency_get_tag();
								}

								// post share
								if (!empty($webency_blog_social)) : ?>
									<div class="shear-link post-share">
										<ul class="dot-style">
											<li><a href="https://www.facebook.com/sharer?u=<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" class="facebook" title="Share this on Facebook"><i class="fa-brands fa-facebook-f"></i></a></li>
											<li><a href="http://twitter.com/intent/tweet?url=<?php the_permalink(); ?>" class="twitter" title="Share this on Twitter" target="_blank"><i class="fa-brands fa-x-twitter"></i></a></li>
											<li><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php the_permalink() ?>&amp;summary=&amp;source=<?php bloginfo('name'); ?>" class="linkedin" title="Share this on Linkedin" target="_blank"><i class="fa-brands fa-linkedin-in"></i></a></li>
											<li><a target="blank" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink() ?>&media=<?php the_post_thumbnail_url('full'); ?>" class="pinteres" title="Pin This Post"><i class="fa-brands fa-pinterest-p"></i></a></li>
										</ul>
									</div>
								<?php endif; ?>
							</div>
						<?php endif; ?>

						<?php if (get_previous_post_link() || get_next_post_link()) : ?>
							<!-- post pagination -->
							<div class="blog-details__pagination">

								<!-- previous post -->
								<?php
								$prevPost = get_adjacent_post(false, '', true);;
								?>

								<?php if (is_a($prevPost, 'WP_Post')) :

									$prevThumbnail = get_the_post_thumbnail($prevPost->ID, [85, 85]);
									$prevTittle = $prevPost->post_title;
									$prevLink = get_permalink($prevPost->ID);
								?>
									<div class="tj_pagination-post previous">

										<div class="tj_pagination_post-inner prev_post">
											<?php if (!empty($prevThumbnail)) : ?>
												<div class="tj-blog-img">
													<a href="<?php echo esc_url($prevLink); ?>">
														<?php echo webency_kses($prevThumbnail); ?>
													</a>
												</div>
											<?php endif; ?>
											<div class="tj-content">
												<div class="post_pagination_nav">
													<i class="fa-regular fa-angle-double-left"></i><?php echo esc_html__('previous', 'webency'); ?>
												</div>
												<div class="post_pagination_title">
													<h5 class="title">
														<a href="<?php echo esc_url($prevLink); ?>"><?php echo wp_trim_words($prevTittle, 8, '...'); ?></a>
													</h5>
												</div>
											</div>
										</div>
									</div>
								<?php endif; ?>

								<!-- next post -->
								<?php
								$nextPost = get_adjacent_post(false, '', false);
								?>

								<?php
								if (is_a($nextPost, 'WP_Post')) :

									$nextThumbnail = get_the_post_thumbnail($nextPost->ID, [85, 85]);
									$nextTittle = $nextPost->post_title;
									$nextLink = get_permalink($nextPost->ID);
								?>
									<div class="tj_pagination-post next">

										<div class="tj_pagination_post-inner next_post">

											<div class="tj-content">
												<div class="post_pagination_nav">
													<?php echo esc_html__('Next', 'webency'); ?><i class="fa-regular fa-angle-double-right"></i>
												</div>
												<div class="post_pagination_title">
													<h5 class="title">
														<a href="<?php echo esc_url($nextLink); ?>"><?php echo wp_trim_words($nextTittle, 8, '...'); ?></a>
													</h5>
												</div>
											</div>
											<?php if (!empty($nextThumbnail)) : ?>
												<div class="tj-blog-img">
													<div class="tj-img">
														<a href="<?php echo esc_url($nextLink); ?>">
															<?php echo webency_kses($nextThumbnail); ?>
														</a>
													</div>
												</div>
											<?php endif; ?>
										</div>
									</div>
								<?php endif; ?>
							</div>
						<?php endif; ?>


					<?php
						// If comments are open or we have at least one comment, load up the comment template.
						if (comments_open() || get_comments_number()) :
							comments_template();
						endif;

					endwhile; // End of the loop.
					?>
				</div>
				<!-- !post details container -->
			</div>

			<?php if (is_active_sidebar('blog-sidebar')) : ?>
				<!-- sidebar -->
				<div class="col-lg-4">
					<aside class="tj-main__sidebar tj-main-sidebar">
						<?php get_sidebar(); ?>
					</aside>
				</div> <!-- !sidebar -->
			<?php endif; ?>

		</div>
	</div>
</div>

<?php
get_footer();
