<?php

/**
 * Template part for displaying post meta
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */
$webency_blog_date = get_theme_mod('webency_blog_date', true);
$webency_blog_comments = get_theme_mod('webency_blog_comments', true);
$webency_blog_author = get_theme_mod('webency_blog_author', true);

?>
<div class="tj-post__meta entry-meta blog-meta">
  <?php if (!empty($webency_blog_author)) : ?>
    <span><i class="flaticon-group"></i>

      <?php printf("<span><a href='%s'>%s %s</a></span>", esc_url(get_author_posts_url(get_the_author_meta('ID'))), esc_html__('By', 'webency'), get_the_author()); ?>
    </span>
  <?php endif; ?>

  <?php if (!empty($webency_blog_date)) : ?>
    <span><i class="flaticon-calendar"></i><?php the_time(get_option('date_format')); ?></span>
  <?php endif; ?>

  <?php if (!empty($webency_blog_comments)) : ?>
    <span><i class="fa-light fa-comments"></i><a href="<?php comments_link(); ?>"><?php comments_number(); ?></a></span>
  <?php endif; ?>
</div>