<?php

/**
 * Template part for displaying page content in page.php
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

?>
<!-- page-<?php the_ID(); ?> -->
<div id="page-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if (has_post_thumbnail()) : ?>
		<!-- page thumbnail -->
		<div class="tj-post__thumb blog-thumb-image">
			<?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>
		</div>
	<?php endif; ?>

	<!-- page content -->
	<div class="tj-entry__content">

		<?php the_content(); ?>

	</div>

	<?php
	wp_link_pages([
		'before'      => '<div class="tj-page__links"> <span class="tj-page-links__title">' . esc_html__('Pages:', 'webency') . '</span>',
		'after'       => '</div>',
		'link_before' => '<span>',
		'link_after'  => '</span>',
		'pagelink'    => '<span class="screen-reader-text">' . esc_html__('Page', 'webency') . ' </span>%',
		'separator'   => '<span class="screen-reader-text"> </span>',
	]);
	?>

	<?php
	if (comments_open() || get_comments_number()) :
		comments_template();
	endif;
	?>
</div> <!-- !page-<?php the_ID(); ?> -->