<?php

/**
 * Template part for displaying video posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

// get video url
$webency_video_url = function_exists('get_field') ? get_field('post_video_link') : "";

if (is_single()) :

  $categories = get_the_terms($post->ID, 'category');
?>

  <!-- single post -->
  <article id="post-<?php the_ID(); ?>" <?php post_class("tj-single__post"); ?>>

    <?php if (has_post_thumbnail()) : ?>
      <!-- post thumbnail -->
      <div class="blog-thumb-image">
        <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>

        <?php if (!empty($webency_video_url)) : ?>
          <div class="video-play">
            <a class="popup-videos-button" href="<?php echo esc_url($webency_video_url); ?>">
              <i class="fa-light fa-circle-play"></i>
            </a>
          </div>
        <?php endif; ?>

        <?php if (!empty($categories[0]->name)) : ?>
          <div class="post_category">
            <a class="category" href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>"><?php echo esc_html($categories[0]->name); ?></a>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>

    <div class="tj-post__content">
      <!-- entry-meta -->
      <?php get_template_part('template-parts/blog/post-meta'); ?>

      <!-- entry content -->
      <div class="tj-entry__content">

        <?php the_content(); ?>

        <?php
        wp_link_pages([
          'before'      => '<div class="tj-page__links"> <span class="tj-page-links__title">' . esc_html__('Pages:', 'webency') . '</span>',
          'after'       => '</div>',
          'link_before' => '<span>',
          'link_after'  => '</span>',
          'pagelink'    => '<span class="screen-reader-text">' . esc_html__('Page', 'webency') . ' </span>%',
          'separator'   => '<span class="screen-reader-text"> </span>',
        ]);
        ?>
      </div>
    </div>
  </article>
  <!-- !single post -->

<?php else :

  $categories = get_the_terms($post->ID, 'category'); ?>

  <!-- post-<?php the_ID(); ?> -->
  <article id="post-<?php the_ID(); ?>" <?php post_class("tj__post tj-post-item wow fadeInUp"); ?> data-wow-delay="0.3s">

    <?php if (has_post_thumbnail()) : ?>
      <!-- post thumbnail -->
      <div class="blog-thumb-image">
        <?php the_post_thumbnail('full', ['class' => 'img-responsive']); ?>

        <?php if (!empty($webency_video_url)) : ?>
          <div class="video-play">
            <a class="popup-videos-button" href="<?php echo esc_url($webency_video_url); ?>">
              <i class="fa-light fa-circle-play"></i>
            </a>
          </div>
        <?php endif; ?>

        <?php if (!empty($categories[0]->name)) : ?>
          <div class="post_category">
            <a class="category" href="<?php echo esc_url(get_category_link($categories[0]->term_id)); ?>"><?php echo esc_html($categories[0]->name); ?></a>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>

    <div class="tj-post__content">
      <!-- entry-meta -->
      <?php get_template_part('template-parts/blog/post-meta'); ?>

      <!-- entry title -->
      <div class="details-title">
        <?php the_title('<h3 class="tj-post__title entry-title title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
      </div>

      <?php if (get_the_excerpt()) : ?>
        <!-- post excerpt -->
        <div class="post_excerpt">
          <?php echo wp_trim_words(get_the_excerpt(), 40, '...'); ?>
        </div>
      <?php endif; ?>

      <!-- post btn -->
      <?php get_template_part('template-parts/blog/post-btn'); ?>
    </div>
    <div class="tj-clearfix"></div>
  </article><!-- !post-<?php the_ID(); ?> -->

<?php endif; ?>