<?php

/**
 * Template part for displaying footer layout Three
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

// from page
$enable_footer_settings = function_exists('get_field') ? get_field('enable_footer_settings') : false;
$page_footer_bg_img = function_exists('get_field') ? get_field('page_footer_bg_img') : '';
$page_footer_bg_color = function_exists('get_field') ? get_field('page_footer_bg_color') : '#FAFAFC';
$page_footer_menu = function_exists('get_field') ? get_field('page_footer_menu') : false;
// footer top
$page_footer_top = function_exists('get_field') ? get_field('page_footer_top') : false;
$page_footer_top_subtitle = function_exists('get_field') ? get_field('page_footer_top_subtitle') : '';
$page_footer_top_title = function_exists('get_field') ? get_field('page_footer_top_title') : '';
$page_footer_top_desc = function_exists('get_field') ? get_field('page_footer_top_desc') : '';
$page_footer_top_contact_label = function_exists('get_field') ? get_field('page_footer_top_contact_label') : '';
$page_footer_top_contact_no = function_exists('get_field') ? get_field('page_footer_top_contact_no') : '';
$page_footer_top_contact_form = function_exists('get_field') ? get_field('page_footer_top_contact_form') : '';

// multifunction
if (!empty($enable_footer_settings)) {
  $footerBgImage = !empty($page_footer_bg_img['url']) ? $page_footer_bg_img['url'] : get_theme_mod('footer_bg_img');
  $footerBgColor = !empty($page_footer_bg_color) ? $page_footer_bg_color : get_theme_mod('footer_bg_color', '#FAFAFC');

  $footerMenu = $page_footer_menu;
  $footerCopyrightMiddleClass = !empty($footerMenu) ? 'justify-content-center justify-content-md-between' : 'justify-content-center';

  // footer top
  $showFooterTop = $page_footer_top;
  $footerTopSubtitle = !empty($page_footer_top_subtitle) ? $page_footer_top_subtitle : get_theme_mod('footer_top_subtitle', esc_html__('Get in touch', 'webency'));
  $footerTopTitle = !empty($page_footer_top_title) ? $page_footer_top_title : get_theme_mod('footer_top_title', webency_kses('Get your Free Trial and <span>Quotation</span>'));
  $footerTopDesc = !empty($page_footer_top_desc) ? $page_footer_top_desc : get_theme_mod('footer_top_desc', webency_kses('All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet.'));
  $footerTopContactLabel = !empty($page_footer_top_contact_label) ? $page_footer_top_contact_label : get_theme_mod('footer_top_contact_label', esc_html__('Help Line:', 'webency'));
  $footerTopContactNo = !empty($page_footer_top_contact_no) ? $page_footer_top_contact_no : get_theme_mod('footer_top_contact_no', esc_attr('+ 00 123 456 789'));
  $footerTopContactForm = !empty($page_footer_top_contact_form) ? $page_footer_top_contact_form : get_theme_mod('footer_top_contact_form', "");
} else {
  $footerBgImage = get_theme_mod('footer_bg_img');
  $footerBgColor = get_theme_mod('footer_bg_color', '#FAFAFC');

  $footerMenu = get_theme_mod('footer_menu_switcher', false);
  $footerCopyrightMiddleClass = !empty($footerMenu) ? 'justify-content-center justify-content-md-between' : 'justify-content-center';

  // footer top
  $showFooterTop = get_theme_mod('footer_top_switcher', false);
  $footerTopSubtitle = get_theme_mod('footer_top_subtitle', esc_html__('Get in touch', 'webency'));
  $footerTopTitle = get_theme_mod('footer_top_title', webency_kses('Get your Free Trial and <span>Quotation</span>'));
  $footerTopDesc = get_theme_mod('footer_top_desc', webency_kses('All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet.'));
  $footerTopContactLabel = get_theme_mod('footer_top_contact_label', esc_html__('Help Line:', 'webency'));
  $footerTopContactNo = get_theme_mod('footer_top_contact_no', esc_attr('+ 00 123 456 789'));
  $footerTopContactForm = get_theme_mod('footer_top_contact_form', "");
}

// footer_columns
$footer_column = 0;
$footer_column = get_theme_mod('footer_widget_column', 4);


switch ($footer_column) {
  case '1':
    $footer_class[1] = 'col-12';
    break;
  case '2':
    $footer_class[1] = 'col-md-6';
    $footer_class[2] = 'col-md-6';
    break;
  case '3':
    $footer_class[1] = 'col-lg-4 col-md-12';
    $footer_class[2] = 'col-lg-4 col-md-6 ';
    $footer_class[3] = 'col-lg-4 col-md-6';
    break;
  case '4':
    $footer_class[1] = 'col-lg-3 col-md-6 col-sm-6';
    $footer_class[2] = 'col-lg-3 col-md-6 col-sm-6';
    $footer_class[3] = 'col-lg-3 col-md-6 col-sm-6';
    $footer_class[4] = 'col-lg-3 col-md-6 col-sm-6';
    break;
  default:
    $footer_class = 'col-lg-3 col-md-6';
    break;
}

// footer bg color
if (!empty($footerBgColor)) {
  $bgColor = 'data-bg-color=' . $footerBgColor . '';
} else {
  $bgColor = "";
}

// footer bg image
if (!empty($footerBgImage)) {
  $bgImage = 'data-bg-image=' . $footerBgImage . '';
} else {
  $bgImage = "";
}
?>

<footer class="tj-footer-area style-3" <?php echo esc_attr($bgColor); ?> <?php echo esc_attr($bgImage); ?>>
  <?php if (!empty($showFooterTop)) : ?>
    <div class="footer-top">
      <div class="container">
        <div class="footer_top_wrap">
          <div class="row align-items-center">
            <div class="col-lg-6">
              <div class="tj-sec-heading">
                <?php if (!empty($footerTopSubtitle)) : ?>
                  <span class="white-sub-title"><?php echo esc_html__($footerTopSubtitle, 'webency'); ?></span>
                <?php endif; ?>

                <?php if (!empty($footerTopTitle)) : ?>
                  <h2 class="sec-title"><?php echo webency_kses($footerTopTitle); ?></h2>
                <?php endif; ?>

                <?php if (!empty($footerTopDesc)) : ?>
                  <div class="desc">
                    <p><?php echo webency_kses($footerTopDesc); ?></p>
                  </div>
                <?php endif; ?>

                <?php if (!empty($footerTopContactNo)) : ?>
                  <div class="contact-list">
                    <div class="contact-icon">
                      <i class="flaticon-conversation"></i>
                    </div>
                    <div class="contact-header">
                      <p class="d-block"><?php echo esc_html__($footerTopContactLabel, 'webency'); ?></p>
                      <a href="tel:<?php echo esc_attr($footerTopContactNo) ?>"><?php echo esc_attr($footerTopContactNo); ?></a>
                    </div>
                  </div>
                <?php endif; ?>

              </div>
            </div>
            <div class="col-lg-6">
              <?php if (!empty($footerTopContactForm)) : ?>
                <div class="contact-form-box3">
                  <?php echo do_shortcode($footerTopContactForm); ?>
                </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <!-- footer widgets -->
  <?php if (is_active_sidebar('footer-3-1') || is_active_sidebar('footer-3-2') || is_active_sidebar('footer-3-3') || is_active_sidebar('footer-3-4') || is_active_sidebar('footer-3-5')) : ?>
    <div class="footer-menu-area">
      <div class="container">
        <div class="row">
          <?php
          for ($num = 1; $num <= $footer_column; $num++) {

            echo '<div class="' . esc_attr($footer_class[$num]) . '">';
            dynamic_sidebar('footer-3-' . $num);
            echo '</div>';
          }
          ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <div class="copyright-area">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <div class="copyright-content-area d-flex align-items-center <?php echo esc_attr($footerCopyrightMiddleClass); ?>">
            <div class="copyright-left-content">
              <p><?php echo webency_copyright_text(); ?></p>
            </div>

            <?php if (!empty($footerMenu)) : ?>
              <div class="copyright-menu">
                <?php if (has_nav_menu('footer-menu')) {
                  webency_footer_menu();
                } ?>
              </div>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</footer>