<?php

/**
 * Template part for displaying footer layout Four
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

// from page
$enable_footer_settings = function_exists('get_field') ? get_field('enable_footer_settings') : false;
$page_footer_bg_img = function_exists('get_field') ? get_field('page_footer_bg_img') : '';
$page_footer_bg_color = function_exists('get_field') ? get_field('page_footer_bg_color') : '#FAFAFC';
$page_footer_menu = function_exists('get_field') ? get_field('page_footer_menu') : false;

// multifunction
if (!empty($enable_footer_settings)) {
  $footerBgImage = !empty($page_footer_bg_img['url']) ? $page_footer_bg_img['url'] : get_theme_mod('footer_bg_img');
  $footerBgColor = !empty($page_footer_bg_color) ? $page_footer_bg_color : get_theme_mod('footer_bg_color', '#FAFAFC');

  $footerMenu = $page_footer_menu;
  $footerCopyrightMiddleClass = !empty($footerMenu) ? 'justify-content-center justify-content-md-between' : 'justify-content-center';
} else {
  $footerBgImage = get_theme_mod('footer_bg_img');
  $footerBgColor = get_theme_mod('footer_bg_color', '#FAFAFC');

  $footerMenu = get_theme_mod('footer_menu_switcher', false);
  $footerCopyrightMiddleClass = !empty($footerMenu) ? 'justify-content-center justify-content-md-between' : 'justify-content-center';
}

// footer_columns
$footer_column = 0;
$footer_column = get_theme_mod('footer_widget_column', 4);


switch ($footer_column) {
  case '1':
    $footer_class[1] = 'col-12';
    break;
  case '2':
    $footer_class[1] = 'col-md-6';
    $footer_class[2] = 'col-md-6';
    break;
  case '3':
    $footer_class[1] = 'col-lg-4 col-md-12';
    $footer_class[2] = 'col-lg-4 col-md-6 ';
    $footer_class[3] = 'col-lg-4 col-md-6';
    break;
  case '4':
    $footer_class[1] = 'col-lg-3 col-md-6 col-sm-6';
    $footer_class[2] = 'col-lg-3 col-md-6 col-sm-6';
    $footer_class[3] = 'col-lg-3 col-md-6 col-sm-6';
    $footer_class[4] = 'col-lg-3 col-md-6 col-sm-6';
    break;
  default:
    $footer_class = 'col-lg-3 col-md-6';
    break;
}

// footer bg color
if (!empty($footerBgColor)) {
  $bgColor = 'data-bg-color=' . $footerBgColor . '';
} else {
  $bgColor = "";
}

// footer bg image
if (!empty($footerBgImage)) {
  $bgImage = 'data-bg-image=' . $footerBgImage . '';
} else {
  $bgImage = "";
}
?>

<footer class="tj-footer-area style-4" <?php echo esc_attr($bgColor); ?> <?php echo esc_attr($bgImage); ?>>

  <?php if (is_active_sidebar('footer-4-1') || is_active_sidebar('footer-4-2') || is_active_sidebar('footer-4-3') || is_active_sidebar('footer-4-4') || is_active_sidebar('footer-4-5')) : ?>
    <div class="footer-menu-area">
      <div class="container">
        <div class="row">
          <?php
          for ($num = 1; $num <= $footer_column; $num++) {

            echo '<div class="' . esc_attr($footer_class[$num]) . '">';
            dynamic_sidebar('footer-4-' . $num);
            echo '</div>';
          }
          ?>
        </div>
      </div>
    </div>
  <?php endif; ?>

  <div class="copyright-area">
    <div class="container">
      <div class="row">
        <div class="col-lg-12">
          <div class="copyright-content-area d-flex align-items-center <?php echo esc_attr($footerCopyrightMiddleClass); ?>">
            <div class="copyright-left-content">
              <p><?php echo webency_copyright_text(); ?></p>
            </div>

            <?php if (!empty($footerMenu)) : ?>
              <div class="copyright-menu">
                <?php if (has_nav_menu('footer-menu')) {
                  webency_footer_menu();
                } ?>
              </div>
            <?php endif; ?>

          </div>
        </div>
      </div>
    </div>
  </div>
</footer>