<?php

/**
 * Template part for displaying header layout one
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Webency_Theme
 * @since Webency 1.0.0
 * @author Theme Junction 
 */

// from Page
$enable_header_settings = function_exists('get_field') ? get_field('enable_header_settings') : false;
$is_page_header_sticky = function_exists('get_field') ? get_field('is_page_header_sticky') : false;
$is_page_header_absolute = function_exists('get_field') ? get_field('is_page_header_absolute') : false;
$page_header_button = function_exists('get_field') ? get_field('page_header_button') : false;
$page_header_button_text = function_exists('get_field') ? get_field('page_header_button_text') : esc_html__('Contact Us', 'webency');
$page_header_button_link = function_exists('get_field') ? get_field('page_header_button_link') : esc_html__('#', 'webency');

// info
$header_sticky = get_theme_mod('header_sticky', false);
$header_absolute = get_theme_mod('header_absolute', false);

// multi condition
if (!empty($enable_header_settings)) {
  $isHeaderSticky = !empty($is_page_header_sticky) ? "header-sticky" : "";
  $isHeaderAbsolute = !empty($is_page_header_absolute) ? "header-absolute" : "";

  // button
  $showHeaderRightButton = $page_header_button;
  $buttonText = !empty($page_header_button_text) ? $page_header_button_text : get_theme_mod('header_right_button_text', esc_html__('Contact Us', 'webency'));
  $buttonLink = !empty($page_header_button_link) ? $page_header_button_link : get_theme_mod('header_right_button_link', esc_html__('#', 'webency'));
} else {

  $isHeaderSticky = !empty($header_sticky) ? "header-sticky" : "";
  $isHeaderAbsolute = !empty($header_absolute) ? "header-absolute" : "";

  // button
  $showHeaderRightButton = get_theme_mod('header_right_button', false);
  $buttonText = get_theme_mod('header_right_button_text', esc_html__('Contact Us', 'webency'));
  $buttonLink = get_theme_mod('header_right_button_link', esc_html__('#', 'webency'));
}
?>

<header class="tj-header-area <?php printf("%s %s", esc_attr($isHeaderAbsolute), esc_attr($isHeaderSticky)); ?>">
  <div class="container">
    <div class="row align-items-center">
      <div class="col-lg-12">
        <div class="header-content-area">
          <div class="logo-area">
            <div class="logo">
              <?php webency_header_logo(); ?>
            </div>
          </div>
          <div class="tj-menu-area d-lg-block d-none" id="main-menu">
            <div id="mobile-menu">
              <?php webency_header_menu(); ?>
            </div>
          </div>

          <?php if (!empty($buttonText && $showHeaderRightButton)) : ?>
            <div class="header-button d-none d-lg-block">
              <a href="<?php echo esc_url($buttonLink); ?>" class="tj-secondary-btn btn-border"><span><?php echo esc_html($buttonText); ?></span></a>
            </div>
          <?php endif; ?>

          <div class="tj-canva-icon d-lg-none">
            <a class="canva_expander nav-menu-link menu-button" href="javascript:void(0)">
              <span class="dot1"></span>
              <span class="dot2"></span>
              <span class="dot3"></span>
              <span class="dot4"></span>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</header>


<!-- Mobile Menu -->
<?php
// from page
$enable_header_settings = function_exists('get_field') ? get_field('enable_header_settings') : false;
$page_header_button = function_exists('get_field') ? get_field('page_header_button') : false;
$page_header_button_text = function_exists('get_field') ? get_field('page_header_button_text') : esc_html__('Contact Us', 'webency');
$page_header_button_link = function_exists('get_field') ? get_field('page_header_button_link') : esc_html__('#', 'webency');

// multi condition
if (!empty($enable_header_settings)) {
  // button
  $showHeaderRightButton = $page_header_button;
  $buttonText = !empty($page_header_button_text) ? $page_header_button_text : get_theme_mod('header_right_button_text', esc_html__('Contact Us', 'webency'));
  $buttonLink = !empty($page_header_button_link) ? $page_header_button_link : get_theme_mod('header_right_button_link', esc_html__('#', 'webency'));
} else {

  $showHeaderRightButton = get_theme_mod('header_right_button', false);
  $buttonText = get_theme_mod('header_right_button_text', esc_html__('Contact Us', 'webency'));
  $buttonLink = get_theme_mod('header_right_button_link', esc_html__('#', 'webency'));
}

// contact info
$contactPhone = get_theme_mod('contact_phone_number', esc_html__('+(081)-2345-6789', 'webency'));
$contactEmail = get_theme_mod('contact_email', esc_html__('mail@webency.com', 'webency'));
$contactLocation = get_theme_mod('contact_location', esc_html__('225 Marion Street, Columbia', 'webency'));

// mobile menu
$mobileSearch = get_theme_mod('webency_mobile_search', false);
$mobileContactPhone = get_theme_mod('webency_mobile_contact_phone', false);
$mobileContactEmail = get_theme_mod('webency_mobile_contact_email', false);
$mobileContactLocation = get_theme_mod('webency_mobile_contact_location', false);
$mobileSocials = get_theme_mod('webency_mobile_socials', false);

?>
<div id="tj-overlay-bg2" class="tj-overlay-canvas d-lg-none"></div>
<div class="tj-offcanvas-area d-lg-none">
  <div class="tj-offcanvas-header d-flex align-items-center justify-content-between">
    <div class="logo-area text-center">
      <?php webency_mobile_logo(); ?>
    </div>
    <div class="offcanvas-icon">
      <button id="canva_close">
        <i class="fa-light fa-xmark"></i>
      </button>
    </div>
  </div>
  <div class="tj-search-box">

    <?php if (!empty($mobileSearch)) : ?>
      <form method="get" action="<?php echo esc_url(home_url('/')); ?>">
        <button type="submit"><i class="fal fa-search"></i></button>
        <input type="search" autocomplete="off" name="s" value="<?php echo esc_attr(get_search_query()) ?>" placeholder="<?php echo esc_attr('Search...'); ?>">
      </form>
    <?php endif; ?>

  </div>
  <nav class="right_menu_togle mobile-navbar-menu d-lg-none" id="mobile-navbar-menu"></nav>

  <div class="mobile-contact">
    <div class="contact-menu">
      <ul class="dot-style">
        <?php if (!empty($contactEmail && $mobileContactEmail)) : ?>
          <li>
            <span><i class="fa-sharp fa-regular fa-envelope"></i></span>
            <a href="mailto:<?php echo esc_attr($contactEmail); ?>"><?php echo esc_html($contactEmail); ?></a>
          </li>
        <?php endif;

        if (!empty($contactPhone && $mobileContactPhone)) : ?>
          <li>
            <span><i class="fa-solid fa-phone-volume"></i></span>
            <a href="tel:<?php echo esc_attr($contactPhone); ?>"><?php echo esc_html($contactPhone); ?></a>
          </li>
        <?php endif;

        if (!empty($contactLocation && $mobileContactLocation)) : ?>
          <li>
            <span><i class="fa-sharp fa-solid fa-location-dot"></i></span>
            <p><?php echo esc_html($contactLocation); ?></p>
          </li>
        <?php endif; ?>

      </ul>
    </div>
  </div>

  <?php if (!empty($mobileSocials)) : ?>
    <div class="mobile-share">
      <?php webency_header_socials(); ?>
    </div>
  <?php endif; ?>

  <?php if (!empty($buttonText && $showHeaderRightButton)) : ?>
    <div class="header-button">
      <a class="btn tj-black-btn" href="<?php echo esc_url($buttonLink); ?>"><?php echo esc_html($buttonText); ?></a>
    </div>
  <?php endif; ?>
</div>